/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.DefaultRenderer;
import javax.swing.Icon;

public class FrameRenderer
extends DefaultRenderer
implements Cloneable {
    protected static final int NONE = 0;
    protected static final int DIRECT = 1;
    protected static final int ALL = 2;
    protected int _instanceCountType = 0;
    protected boolean _hasLoadedIconFlags = false;
    protected boolean _displayFrameTypeIcon = true;
    protected boolean _displayAbstractIcon = true;
    protected boolean _displayMultipleParentsIcon = true;
    protected boolean _displayDefaultMetaclassIcon = true;
    protected boolean _displayHiddenIcon = true;
    protected boolean _displayType = false;
    protected static FrameRenderer _frameRendererPrototype = new FrameRenderer();

    public static FrameRenderer createInstance() {
        FrameRenderer frameRenderer;
        try {
            frameRenderer = (FrameRenderer)_frameRendererPrototype.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            frameRenderer = null;
        }
        return frameRenderer;
    }

    protected void ensureIconFlagsLoaded() {
        Project project;
        if (!this._hasLoadedIconFlags && (project = ProjectManager.getProjectManager().getCurrentProject()) != null) {
            this._displayAbstractIcon = project.getDisplayAbstractClassIcon();
            this._displayMultipleParentsIcon = project.getDisplayMultiParentClassIcon();
            this._hasLoadedIconFlags = true;
        }
    }

    protected String getInstanceCountString(Cls cls) {
        int n;
        switch (this._instanceCountType) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = cls.getDirectInstanceCount();
                break;
            }
            case 2: {
                n = cls.getInstanceCount();
                break;
            }
            default: {
                Assert.fail("bad type: " + this._instanceCountType);
                n = 0;
            }
        }
        String string = n > 0 ? "  (" + n + ")" : "";
        return string;
    }

    public void setDisplayType(boolean bl) {
        this._displayType = bl;
    }

    public void loadDuplicate(Object object) {
        this.load(object);
        this.appendText("   (recursive)");
    }

    public void load(Object object) {
        this.ensureIconFlagsLoaded();
        if (object instanceof Frame) {
            Frame frame = (Frame)object;
            if (!frame.isEditable()) {
                this.setGrayedText(true);
            }
            if (frame.isDeleted()) {
                this.setMainIcon(null);
                this.setMainText("<deleted frame>");
            } else if (frame instanceof Cls) {
                this.loadCls((Cls)object);
            } else if (frame instanceof Slot) {
                this.loadSlot((Slot)object);
            } else if (frame instanceof Facet) {
                this.loadFacet((Facet)object);
            } else if (frame instanceof SimpleInstance) {
                this.loadInstance((Instance)object);
            }
        } else {
            this.setMainIcon(null);
            this.setMainText(object.toString());
        }
    }

    protected Icon getIcon(Cls cls) {
        return cls.getIcon();
    }

    protected void loadCls(Cls cls) {
        this.setMainIcon(this.getIcon(cls));
        this.setMainText(cls.getBrowserText());
        this.appendText(this.getInstanceCountString(cls));
        this.appendType(cls);
        this.setBackgroundSelectionColor(Colors.getClsSelectionColor());
    }

    protected void loadFacet(Facet facet) {
        this.setMainIcon(facet.getIcon());
        this.setMainText(facet.getBrowserText());
        this.appendType(facet);
    }

    protected void loadInstance(Instance instance) {
        String string = instance.getBrowserText();
        this.setMainText(string);
        this.setMainIcon(instance.getIcon());
        this.appendType(instance);
        this.setBackgroundSelectionColor(Colors.getInstanceSelectionColor());
    }

    public void loadNull() {
    }

    protected void loadSlot(Slot slot) {
        this.setMainIcon(slot.getIcon());
        this.setMainText(slot.getBrowserText());
        this.appendType(slot);
        this.setBackgroundSelectionColor(Colors.getSlotSelectionColor());
    }

    private void appendType(Instance instance) {
        if (this._displayType) {
            String string = instance.getDirectType().getBrowserText();
            this.appendText("  (" + string + ")");
        }
    }

    public void setDisplayDirectInstanceCount(boolean bl) {
        this._instanceCountType = bl ? 1 : 0;
    }

    public void setDisplayFrameTypeIcon(boolean bl) {
        this._displayFrameTypeIcon = bl;
    }

    public void setDisplayHiddenIcon(boolean bl) {
        this._displayHiddenIcon = bl;
    }

    public void setDisplayInstanceCount(boolean bl) {
        this._instanceCountType = bl ? 2 : 0;
    }

    public void setDisplayTrailingIcons(boolean bl) {
        this._displayAbstractIcon = bl;
        this._displayMultipleParentsIcon = bl;
        this._displayDefaultMetaclassIcon = bl;
        this._hasLoadedIconFlags = true;
    }

    public void setMainIcon(Icon icon) {
        if (this._displayFrameTypeIcon) {
            super.setMainIcon(icon);
        }
    }

    public static void setPrototypeInstance(FrameRenderer frameRenderer) {
        _frameRendererPrototype = frameRenderer;
    }
}

