/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;

class RemoveRowAction
extends AbstractOWLTableAction {
    private ClassDescriptionTable table;

    RemoveRowAction(ClassDescriptionTable table) {
        super("Remove selected class from list", OWLIcons.getRemoveIcon("PrimitiveClass"));
        this.table = table;
    }

    public void actionPerformed(ActionEvent e) {
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this.table));
        int[] sels = this.table.getSelectedRows();
        Arrays.sort(sels);
        OWLNamedClass editedClass = this.table.getEditedCls();
        int i = sels.length - 1;
        while (i >= 0) {
            int selIndex = sels[i];
            OWLTableModel tableModel = (OWLTableModel)this.table.getModel();
            RDFSClass cls = tableModel.getClass(selIndex);
            if (tableModel.isCellEditable(selIndex, tableModel.getSymbolColumnIndex()) || cls.equals(cls.getKnowledgeBase().getRootCls())) {
                tableModel.deleteRow(selIndex);
                this.table.getSelectionModel().setSelectionInterval(selIndex, selIndex);
            }
            --i;
        }
        if (tab != null) {
            tab.ensureClsSelected(editedClass, -1);
        }
    }

    public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
        ClassDescriptionTableModel tableModel = (ClassDescriptionTableModel)this.table.getModel();
        return cls != null && tableModel.isRemoveEnabledFor(cls);
    }
}

