/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.io.IOException;
import java.util.List;

/**
 * Implementations of this class can be used to search service instance.
 * 
 * @author tilmann
 */
public interface ServiceInstanceLocator {

	/**
	 * Invoce this method to search for service instances that conform to the
	 * given search parameters.
	 * 
	 * @param searchParameter
	 *            the parameter used during search
	 * @return all instances found
	 */
	public List<ServiceInstanceInfo> findSeviceInstances(
			ServiceInstanceParameter searchParameter) throws IOException;

}
