/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.util.EventListener;

/**
 * Implementing classes can be notified of events occuring during service
 * lookup.
 * 
 * @author tilmann
 */
public interface ServiceLocatorEventListener extends EventListener {

	/**
	 * This event is fired when a class name provided as a search parameter
	 * cannot be resolved to an ontology class.
	 * 
	 * @param e
	 *            the ClassNotFoundEvent
	 */
	public void classNotFound(ClassNotFoundEvent e);

}
