/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.plugin.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

/**
 * This is an Editor used to render the search results. In the moment it does
 * just render html source.
 * 
 * @author tilmann
 */
public class SearchResultsEditor extends EditorPart {

	private Browser browser;

	private String html;

	@Override
	public void createPartControl(Composite parent) {

		// Create SWT Browser and set html source
		browser = new Browser(parent, SWT.NONE);
		browser.setText(html);
	}

	@Override
	public void init(IEditorSite site, IEditorInput input)
			throws PartInitException {

		setSite(site);
		setInput(input);
		setPartName(input.getName());

		// Retrieve html source
		html = ((SearchResultsEditorInput) input).getHtml();
	}

	@Override
	public void doSave(IProgressMonitor monitor) {
	}

	@Override
	public void doSaveAs() {
	}

	@Override
	public boolean isDirty() {
		return false;
	}

	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}

	@Override
	public void setFocus() {
	}

}
