/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextAreaPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.DefaultOWLTableTransferHandler;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableTransferHandler;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTable;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JComponent;

public abstract class OWLTable
extends SymbolTable {
    private OWLTableAction copyAction = new AbstractOWLTableAction("Copy", OWLIcons.getCopyIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLTable.this.transferHandler.exportToClipboard((JComponent)((Object)OWLTable.this), OWLTable.this.getClipboard(), 1);
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return OWLTable.this.getOWLTableModel().getClass(rowIndex) != null;
        }
    };
    private OWLTableAction cutAction = new AbstractOWLTableAction("Cut", OWLIcons.getCutIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLTable.this.getTransferHandler().exportToClipboard((JComponent)((Object)OWLTable.this), OWLTable.this.getClipboard(), 2);
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            OWLTableModel tableModel = OWLTable.this.getOWLTableModel();
            return tableModel.isEditable() && tableModel.getClass(rowIndex) != null && tableModel.isDeleteEnabledFor(tableModel.getClass(rowIndex));
        }
    };
    private OWLTableAction pasteAction = new AbstractOWLTableAction("Paste", OWLIcons.getPasteIcon()){

        public void actionPerformed(ActionEvent e) {
            Transferable trans = OWLTable.this.getClipboard().getContents(null);
            if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                OWLTable.this.transferHandler.importData((JComponent)((Object)OWLTable.this), trans);
            }
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            OWLTableModel tableModel = OWLTable.this.getOWLTableModel();
            if (tableModel.isEditable()) {
                try {
                    Transferable trans = OWLTable.this.getClipboard().getContents(null);
                    if (trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        return tableModel.isAddEnabledAt(rowIndex);
                    }
                }
                catch (HeadlessException he) {
                    return false;
                }
            }
            return false;
        }
    };
    private OWLTableAction viewClsAction = new AbstractOWLTableAction("Edit/View named class...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLTable.this.viewSelectedCls();
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return cls instanceof RDFSNamedClass;
        }
    };
    private OWLTableTransferHandler transferHandler;

    public OWLTable(OWLTableModel tableModel, OWLModel owlModel, boolean withIcon) {
        super(tableModel, owlModel, withIcon, new OWLSymbolPanel(owlModel, true, true));
        this.registerAction(this.editMultiLineAction);
        this.registerAction(this.viewClsAction);
        this.registerAction(this.editAnnotationsAction);
        this.registerActionSeparator();
        this.registerAction(this.copyAction);
        this.registerAction(this.cutAction);
        this.registerAction(this.pasteAction);
        this.registerActionSeparator();
        try {
            this.setDragEnabled(OWLUI.isDragAndDropSupported(owlModel));
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        this.transferHandler = new DefaultOWLTableTransferHandler(owlModel);
        this.setTransferHandler(this.transferHandler);
    }

    protected ResourceRenderer createOWLFrameRenderer() {
        return new ResourceRenderer();
    }

    protected String editMultiLine(RDFResource input) {
        return OWLTextAreaPanel.showEditDialog((Component)((Object)this), this.getOWLModel(), (RDFSClass)input);
    }

    public void enableActions(Collection actions) {
        OWLTableModel tableModel = this.getOWLTableModel();
        for (OWLTableAction action : actions) {
            if (action == null) continue;
            if (this.isEnabled()) {
                if (this.getSelectionModel().getSelectionMode() == 0) {
                    int sel = this.getSelectedRow();
                    if (sel >= 0 && sel < tableModel.getRowCount()) {
                        RDFSClass superclass = tableModel.getClass(sel);
                        boolean enabled = action.isEnabledFor(superclass, sel);
                        action.setEnabled(enabled);
                        continue;
                    }
                    action.setEnabled(false);
                    continue;
                }
                int[] sels = this.getSelectedRows();
                boolean en = sels.length > 0;
                boolean one = false;
                int i = 0;
                while (i < sels.length) {
                    int sel = sels[i];
                    if (sel < tableModel.getRowCount()) {
                        one = true;
                        RDFSClass superclass = tableModel.getClass(sel);
                        if (!action.isEnabledFor(superclass, sel)) {
                            en = false;
                            break;
                        }
                    }
                    ++i;
                }
                action.setEnabled(en && one);
                continue;
            }
            action.setEnabled(false);
        }
    }

    public OWLNamedClass getEditedCls() {
        return this.getOWLTableModel().getEditedCls();
    }

    protected Collection getNavigationMenuItems(RDFResource resource) {
        if (OWLClassesTab.getOWLClassesTab((Component)((Object)this)) != null) {
            HashSet set = new HashSet();
            RDFSClass rdfsClass = (RDFSClass)resource;
            rdfsClass.getNestedNamedClasses(set);
            return set;
        }
        return Collections.EMPTY_LIST;
    }

    public OWLTableModel getOWLTableModel() {
        return (OWLTableModel)this.getSymbolTableModel();
    }

    public Cls getSelectedCls() {
        OWLTableModel tableModel = this.getOWLTableModel();
        int index = this.getSelectedRow();
        if (index >= 0 && index < tableModel.getRowCount()) {
            return tableModel.getClass(index);
        }
        return null;
    }

    protected String getToolTipText(RDFResource resource) {
        String str = OWLUI.getOWLToolTipText(resource);
        if (str != null && str.length() > 0) {
            return str;
        }
        return null;
    }

    protected void navigateTo(RDFResource instance) {
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        if (tab != null && instance instanceof RDFSNamedClass) {
            tab.setSelectedCls((RDFSNamedClass)instance);
        }
    }

    public void setCls(OWLNamedClass cls) {
        if (this.getSymbolCellEditor() != null) {
            this.getSymbolCellEditor().cancelCellEditing();
        }
        this.hideSymbolPanel();
        this.getOWLTableModel().setCls(cls);
    }

    public void setValueAt(Object aValue, int row, int column) {
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        super.setValueAt(aValue, row, column);
        if (tab != null) {
            tab.ensureClassSelected(this.getEditedCls(), -1);
        }
    }

    private void viewSelectedCls() {
        this.editAnnotations();
    }
}

