/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.Transformator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;

public class GenericTransformator
implements Transformator {
    public static final char STARTMULTI = '(';
    public static final char ENDMULTI = ')';
    Object[] ruleArray = null;

    public GenericTransformator(File file) throws IOException {
        this.buildRules(new BufferedReader(new FileReader(file)));
    }

    public String transform(String string) {
        if (this.ruleArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        int n = stringBuffer.length();
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            n3 = 1;
            int n4 = 0;
            while (n4 < this.ruleArray.length) {
                TransformationRule transformationRule = (TransformationRule)this.ruleArray[n4];
                if ((!transformationRule.startsWithExp() || n2 <= 0) && n2 + transformationRule.lengthOfMatch() < n && transformationRule.isMatching(stringBuffer, n2)) {
                    stringBuffer.replace(n2, n2 + transformationRule.getTakeOut(), transformationRule.getReplaceExp());
                    n3 = transformationRule.getReplaceExp().length();
                    n -= transformationRule.getTakeOut();
                    n += n3;
                    break;
                }
                ++n4;
            }
            n2 += n3;
        }
        return stringBuffer.toString();
    }

    private void buildRules(BufferedReader bufferedReader) throws IOException {
        String string = null;
        LinkedList linkedList = new LinkedList();
        while ((string = bufferedReader.readLine()) != null) {
            this.buildRule(this.realTrimmer(string), linkedList);
        }
        this.ruleArray = linkedList.toArray();
    }

    private void buildRule(String string, LinkedList linkedList) {
        if (string.length() < 1) {
            return;
        }
        if (string.startsWith("version")) {
            return;
        }
        TransformationRule transformationRule = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        boolean bl3 = true;
        boolean bl4 = false;
        int n3 = 0;
        while (n3 < string.length()) {
            if (Character.isWhitespace(string.charAt(n3))) {
                bl3 = false;
            } else if (bl3) {
                if (!this.isReservedChar(string.charAt(n3))) {
                    stringBuffer.append(string.charAt(n3));
                    if (!bl4) {
                        ++n;
                        ++n2;
                    }
                    if (string.charAt(n3) == '(' || string.charAt(n3) == ')') {
                        boolean bl5 = bl4 = !bl4;
                    }
                }
                if (string.charAt(n3) == '-') {
                    --n;
                }
                if (string.charAt(n3) == '^') {
                    bl = true;
                }
                if (string.charAt(n3) == '$') {
                    bl2 = true;
                }
            } else {
                stringBuffer2.append(string.charAt(n3));
            }
            ++n3;
        }
        transformationRule = new TransformationRule(stringBuffer.toString(), stringBuffer2.toString(), n, n2, bl, bl2);
        linkedList.add(transformationRule);
    }

    private boolean isReservedChar(char c) {
        return c == '<' || c == '>' || c == '^' || c == '$' || c == '-' || Character.isDigit(c);
    }

    private String realTrimmer(String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    private class TransformationRule {
        private String replace;
        private char[] match;
        private int takeOut;
        private int matchLength;
        private boolean start;
        private boolean end;

        public TransformationRule(String string, String string2, int n, int n2, boolean bl, boolean bl2) {
            this.match = string.toCharArray();
            this.replace = string2;
            this.takeOut = n;
            this.matchLength = n2;
            this.start = bl;
            this.end = bl2;
        }

        public boolean isMatching(StringBuffer stringBuffer, int n) {
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < this.match.length) {
                char c = this.match[n2];
                if (c == '(' || c == ')') {
                    boolean bl4 = bl2 = !bl2;
                    if (!bl2) {
                        bl &= bl3;
                    } else {
                        bl3 = false;
                    }
                } else {
                    if (c != stringBuffer.charAt(n)) {
                        if (bl2) {
                            bl3 |= false;
                        } else {
                            bl = false;
                        }
                    } else if (bl2) {
                        bl3 |= true;
                    } else {
                        bl = true;
                    }
                    if (!bl2) {
                        ++n;
                    }
                    if (!bl) break;
                }
                ++n2;
            }
            if (this.end && n != stringBuffer.length() - 1) {
                bl = false;
            }
            return bl;
        }

        public String getReplaceExp() {
            return this.replace;
        }

        public int getTakeOut() {
            return this.takeOut;
        }

        public boolean startsWithExp() {
            return this.start;
        }

        public int lengthOfMatch() {
            return this.matchLength;
        }

        public String toString() {
            return "Match:" + String.valueOf(this.match) + " Replace:" + this.replace + " TakeOut:" + this.takeOut + " MatchLength:" + this.matchLength + " Start:" + this.start + " End:" + this.end;
        }
    }
}

