/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Log;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TransferableCollection
implements Transferable {
    private static final Collection flavors = new ArrayList();
    private static DataFlavor collectionFlavor;
    private ArrayList frames;

    public TransferableCollection(Collection collection) {
        this.frames = new ArrayList(collection);
    }

    public static DataFlavor getCollectionFlavor() {
        return collectionFlavor;
    }

    public Object getTransferData(DataFlavor dataFlavor) {
        Object object = dataFlavor.equals(collectionFlavor) ? this.getCollectionTransferData() : (dataFlavor.equals(DataFlavor.stringFlavor) ? this.getStringTransferData() : null);
        return object;
    }

    public Object getCollectionTransferData() {
        return new ArrayList(this.frames);
    }

    public Object getStringTransferData() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            Frame frame = (Frame)iterator.next();
            String string = frame.getName();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return flavors.contains(dataFlavor);
    }

    static {
        try {
            String string = ArrayList.class.getName();
            String string2 = "application/x-java-jvm-local-objectref; class=" + string;
            collectionFlavor = new DataFlavor(string2);
            flavors.add(collectionFlavor);
            flavors.add(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            Log.getLogger().warning(Log.toString(exception));
        }
    }
}

