/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.DataSetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.junit.TestScripts;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import junit.framework.TestCase;

public class QueryTest
extends TestCase {
    static int testCounter = 1;
    static boolean printModelsOnFailure = false;
    Model model;
    int testNumber = testCounter++;
    TestItem testItem;
    FileManager queryFileManager;
    Model resultsModel = null;
    String description = null;

    QueryTest(Model model, String string, FileManager fileManager, TestItem testItem) {
        super(string);
        this.model = model;
        this.queryFileManager = fileManager;
        this.testItem = testItem;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.description = this.makeDescription();
        if (this.testItem.getResultFile() != null) {
            this.resultsModel = FileManager.get().loadModel(this.testItem.getResultFile());
            if (this.resultsModel.isEmpty()) {
                TestScripts.log.warn((Object)("Empty results model: " + this.testItem.getResultFile()));
            }
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private DataSet setUpDataSet(Query query2, TestItem testItem) {
        try {
            if (QueryTest.doesQueryHaveDataset(query2) && testItem.getDataFiles() != null && testItem.getDataFiles().size() > 0) {
                TestScripts.log.warn((Object)(testItem.name + " : query data source and also in test file"));
            }
            if (testItem.getDataFiles() != null && testItem.getDataFiles().size() != 0) {
                List list = testItem.getDataFiles();
                return DataSetFactory.create(list);
            }
            if (!QueryTest.doesQueryHaveDataset(query2)) {
                QueryTest.fail((String)"No dataset");
            }
            return null;
        }
        catch (JenaException jenaException) {
            TestScripts.log.debug((Object)("JenaException: " + jenaException.getMessage()));
            QueryTest.fail((String)("JenaException creating data source: " + jenaException.getMessage()));
            return null;
        }
    }

    private static boolean doesQueryHaveDataset(Query query2) {
        boolean bl = query2.getGraphURIs() != null && query2.getGraphURIs().size() > 0 || query2.getNamedGraphURIs() != null && query2.getNamedGraphURIs().size() > 0;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        Query query2 = null;
        try {
            if (this.testItem.getQueryFile() == null) {
                QueryTest.fail((String)"Query test file is null");
                return;
            }
            try {
                query2 = QueryFactory.read(this.testItem.getQueryFile(), null, this.testItem.getQueryFileSyntax());
            }
            catch (QueryException queryException) {
                query2 = null;
                QueryTest.fail((String)("Parse failure: " + queryException.getMessage()));
                throw queryException;
            }
            query2.setBaseURI(this.testItem.getBaseURI());
            DataSet dataSet = this.setUpDataSet(query2, this.testItem);
            if (dataSet == null && !QueryTest.doesQueryHaveDataset(query2)) {
                QueryTest.fail((String)"No dataset for query");
            }
            QueryExecution queryExecution = null;
            try {
                queryExecution = dataSet != null ? QueryExecutionFactory.create(query2, dataSet) : QueryExecutionFactory.create(query2, dataSet);
                QueryExecutionFactory.create(query2, this.queryFileManager);
                queryExecution.init();
                if (query2.isSelectType()) {
                    this.runTestSelect(query2, queryExecution);
                } else if (query2.isConstructType()) {
                    this.runTestConstruct(query2, queryExecution);
                } else if (query2.isDescribeType()) {
                    this.runTestDescribe(query2, queryExecution);
                } else if (query2.isAskType()) {
                    this.runTestAsk(query2, queryExecution);
                }
            }
            finally {
                queryExecution.close();
            }
        }
        catch (IOException iOException) {
            QueryTest.fail((String)("IOException: " + iOException.getMessage()));
            throw iOException;
        }
        catch (Exception exception) {
            TestScripts.log.debug((Object)("Exception: " + exception.getMessage()), (Throwable)exception);
            QueryTest.fail((String)("Exception: " + exception.getClass().getName() + ": " + exception.getMessage()));
        }
    }

    void runTestSelect(Query query2, QueryExecution queryExecution) throws Exception {
        ResultSet resultSet = queryExecution.execSelect();
        ResultSetRewindable resultSetRewindable = ResultSetFactory.makeRewindable(resultSet);
        queryExecution.close();
        resultSet = null;
        if (this.resultsModel != null) {
            try {
                ResultSetRewindable resultSetRewindable2 = ResultSetFactory.makeRewindable(resultSetRewindable);
                ResultSetRewindable resultSetRewindable3 = ResultSetFactory.makeRewindable(this.resultsModel);
                if (!QueryTest.resultSetEquivalent(query2, resultSetRewindable2, resultSetRewindable3)) {
                    this.printFailedResultSetTest(query2, resultSetRewindable2, resultSetRewindable3);
                    QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception exception) {
                TestScripts.log.warn((Object)"Exception in result testing", (Throwable)exception);
                QueryTest.fail((String)("Exception in result testing: " + exception));
            }
        }
    }

    public static boolean resultSetEquivalent(Query query2, ResultSet resultSet, ResultSet resultSet2) {
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter(resultSet);
        Model model = resultSetFormatter.toModel();
        long l = model.size();
        ResultSetFormatter resultSetFormatter2 = new ResultSetFormatter(resultSet2);
        Model model2 = resultSetFormatter2.toModel();
        long l2 = model.size();
        return model.isIsomorphicWith(model2);
    }

    void runTestConstruct(Query query2, QueryExecution queryExecution) throws Exception {
        Model model = queryExecution.execConstruct();
        if (this.resultsModel != null) {
            try {
                if (!this.resultsModel.isIsomorphicWith(model)) {
                    this.printFailedModelTest(query2, model, this.resultsModel);
                    QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception exception) {
                TestScripts.log.warn((Object)"Exception in result testing (construct)", (Throwable)exception);
                QueryTest.fail((String)("Exception in result testing: " + exception));
            }
        }
    }

    void runTestDescribe(Query query2, QueryExecution queryExecution) throws Exception {
        System.err.println("Not implmented: runTestDescribe");
    }

    void runTestAsk(Query query2, QueryExecution queryExecution) throws Exception {
        System.err.println("Not implmented: runTestDescribe");
    }

    void printFailedResultSetTest(Query query2, ResultSetRewindable resultSetRewindable, ResultSetRewindable resultSetRewindable2) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        printWriter.println();
        printWriter.println("=======================================");
        printWriter.println("Failure: " + this.description);
        printWriter.println("Got: " + resultSetRewindable.size() + " --------------------------------");
        resultSetRewindable.reset();
        ResultSetFormatter resultSetFormatter = new ResultSetFormatter((ResultSet)resultSetRewindable, query2.getPrefixMapping());
        resultSetFormatter.printAll(printWriter);
        resultSetRewindable.reset();
        if (printModelsOnFailure) {
            printWriter.println("-----------------------------------------");
            resultSetFormatter.toModel().write((Writer)printWriter, "N3");
            resultSetRewindable.reset();
        }
        printWriter.flush();
        resultSetRewindable2.reset();
        ResultSetFormatter resultSetFormatter2 = new ResultSetFormatter((ResultSet)resultSetRewindable2, query2.getPrefixMapping());
        printWriter.println("Expected: " + resultSetRewindable2.size() + " -----------------------------");
        resultSetFormatter2.printAll(printWriter);
        resultSetRewindable2.reset();
        if (printModelsOnFailure) {
            printWriter.println("---------------------------------------");
            resultSetFormatter2.toModel().write((Writer)printWriter, "N3");
            resultSetRewindable2.reset();
        }
        printWriter.println();
        printWriter.flush();
    }

    void printFailedModelTest(Query query2, Model model, Model model2) {
        PrintWriter printWriter = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        printWriter.println("=======================================");
        printWriter.println("Failure: " + this.description);
        if (printModelsOnFailure) {
            model.write((Writer)printWriter, "N3");
            printWriter.println("---------------------------------------");
            model2.write((Writer)printWriter, "N3");
        }
        printWriter.println();
    }

    public String toString() {
        if (this.testItem.getName() != null) {
            return this.testItem.getName();
        }
        return super.getName();
    }

    String makeDescription() {
        Object object;
        String string = "";
        if (this.testItem.getDataFiles() != null) {
            object = this.testItem.getDataFiles().iterator();
            while (object.hasNext()) {
                this.description = string + (String)object.next();
            }
        }
        object = "Test " + this.testNumber + " :: " + this.testItem.getName();
        return object;
    }
}

