/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class CreatePropertyRangesTestCase
extends AbstractProtege2JenaTestCase {
    public void testDataRangeDefault() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", new RDFSLiteral[]{this.owlModel.createRDFSLiteral("A"), this.owlModel.createRDFSLiteral("B")});
        OntModel newModel = this.createOntModel();
        DatatypeProperty datatypeProperty = newModel.getDatatypeProperty(slot.getURI());
        OntResource range = datatypeProperty.getRange();
        CreatePropertyRangesTestCase.assertTrue((boolean)range.canAs(DataRange.class));
        DataRange dataRange = (DataRange)range.as(DataRange.class);
        ExtendedIterator it = dataRange.listOneOf();
        CreatePropertyRangesTestCase.assertEquals((Object)newModel.createTypedLiteral("A"), it.next());
        CreatePropertyRangesTestCase.assertEquals((Object)newModel.createTypedLiteral("B"), it.next());
        CreatePropertyRangesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testDataRangeInt() {
        XSDDatatype xsd = XSDDatatype.XSDpositiveInteger;
        RDFSDatatype positiveInteger = this.owlModel.getRDFSDatatypeByURI(xsd.getURI());
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", new RDFSLiteral[]{this.owlModel.createRDFSLiteral("42", positiveInteger), this.owlModel.createRDFSLiteral("43", positiveInteger)});
        OntModel newModel = this.createOntModel();
        DatatypeProperty datatypeProperty = newModel.getDatatypeProperty(slot.getURI());
        OntResource range = datatypeProperty.getRange();
        CreatePropertyRangesTestCase.assertTrue((boolean)range.canAs(DataRange.class));
        DataRange dataRange = (DataRange)range.as(DataRange.class);
        ExtendedIterator it = dataRange.listOneOf();
        CreatePropertyRangesTestCase.assertEquals((Object)newModel.createTypedLiteral("42", (RDFDatatype)xsd), it.next());
        CreatePropertyRangesTestCase.assertEquals((Object)newModel.createTypedLiteral("43", (RDFDatatype)xsd), it.next());
        CreatePropertyRangesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testDatatypeRanges() {
        OWLDatatypeProperty booleanProperty = this.owlModel.createOWLDatatypeProperty("booleanProperty", this.owlModel.getXSDboolean());
        OWLDatatypeProperty floatProperty = this.owlModel.createOWLDatatypeProperty("floatProperty", this.owlModel.getXSDfloat());
        OWLDatatypeProperty intProperty = this.owlModel.createOWLDatatypeProperty("intProperty", this.owlModel.getXSDint());
        OWLDatatypeProperty stringProperty = this.owlModel.createOWLDatatypeProperty("stringProperty", this.owlModel.getXSDstring());
        OWLDatatypeProperty dateProperty = this.owlModel.createOWLDatatypeProperty("dateProperty", this.owlModel.getRDFSDatatypeByURI(XSDDatatype.XSDdate.getURI()));
        OntModel newModel = this.createOntModel();
        CreatePropertyRangesTestCase.assertEquals((String)XMLSchemaDatatypes.getValueTypeURI(ValueType.BOOLEAN), (String)newModel.getDatatypeProperty(booleanProperty.getURI()).getRange().getURI());
        CreatePropertyRangesTestCase.assertEquals((String)XMLSchemaDatatypes.getValueTypeURI(ValueType.FLOAT), (String)newModel.getDatatypeProperty(floatProperty.getURI()).getRange().getURI());
        CreatePropertyRangesTestCase.assertEquals((String)XMLSchemaDatatypes.getValueTypeURI(ValueType.INTEGER), (String)newModel.getDatatypeProperty(intProperty.getURI()).getRange().getURI());
        CreatePropertyRangesTestCase.assertEquals((String)XMLSchemaDatatypes.getValueTypeURI(ValueType.STRING), (String)newModel.getDatatypeProperty(stringProperty.getURI()).getRange().getURI());
        CreatePropertyRangesTestCase.assertEquals((String)XSDDatatype.XSDdate.getURI(), (String)newModel.getDatatypeProperty(dateProperty.getURI()).getRange().getURI());
    }

    public void testObjectPropertyRangeMultiple() {
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("ClsA");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("ClsB");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setUnionRangeClasses(Arrays.asList(clsA, clsB));
        OntModel newModel = this.createOntModel();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        OntResource range = property.getRange();
        CreatePropertyRangesTestCase.assertTrue((boolean)range.canAs(UnionClass.class));
        UnionClass unionClass = (UnionClass)range.as(UnionClass.class);
        ExtendedIterator it = unionClass.listOperands();
        CreatePropertyRangesTestCase.assertEquals((Object)newModel.getResource(clsA.getURI()), it.next());
        CreatePropertyRangesTestCase.assertEquals((Object)newModel.getResource(clsB.getURI()), it.next());
        CreatePropertyRangesTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testObjectPropertyRangeSingle() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setUnionRangeClasses(Collections.singleton(cls));
        OntModel newModel = this.createOntModel();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        CreatePropertyRangesTestCase.assertEquals((Object)newModel.getResource(cls.getURI()), (Object)property.getRange());
    }

    public void testRDFPropertyRangeBoolean() {
        RDFProperty slot = this.owlModel.createRDFProperty("slot");
        slot.setRange(this.owlModel.getXSDboolean());
        OntModel ontModel = this.createOntModel();
        OntProperty property = ontModel.getOntProperty(slot.getURI());
        OntResource range = property.getRange();
        CreatePropertyRangesTestCase.assertEquals((String)XMLSchemaDatatypes.getDefaultXSDDatatype(ValueType.BOOLEAN).getURI(), (String)range.getURI());
    }

    public void testRDFPropertyRangeInstance() {
        RDFSNamedClass aClass = this.owlModel.createRDFSNamedClass("Cls");
        RDFProperty rdfProperty = this.owlModel.createRDFProperty("rdfProperty");
        rdfProperty.setRange(aClass);
        OntModel ontModel = this.createOntModel();
        OntProperty ontProperty = ontModel.getOntProperty(rdfProperty.getURI());
        CreatePropertyRangesTestCase.assertSize(1, (Iterator)ontProperty.listRange());
        CreatePropertyRangesTestCase.assertEquals((Object)ontModel.getOntClass(aClass.getURI()), (Object)ontProperty.getRange());
    }

    public void testSubslotRange() {
        Slot valueTypeSlot = this.owlModel.getSlot(":SLOT-VALUE-TYPE");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty superSlot = this.owlModel.createOWLObjectProperty("superSlot");
        OWLObjectProperty subSlot = (OWLObjectProperty)this.owlModel.createSubproperty("subSlot", superSlot);
        superSlot.setUnionRangeClasses(Collections.singleton(cls));
        CreatePropertyRangesTestCase.assertSize(1, subSlot.getUnionRangeClasses());
        CreatePropertyRangesTestCase.assertNull((Object)subSlot.getDirectOwnSlotValue(valueTypeSlot));
        OntModel newModel = this.createOntModel();
        OntProperty superProperty = newModel.getOntProperty(superSlot.getURI());
        CreatePropertyRangesTestCase.assertNotNull((Object)superProperty.getRange());
        OntProperty subProperty = newModel.getOntProperty(subSlot.getURI());
        CreatePropertyRangesTestCase.assertNull((Object)subProperty.getRange());
    }
}

