/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.restrictions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.InstanceNameComponent;
import edu.stanford.smi.protegex.owl.ui.restrictions.FillerTextArea;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionKindRenderer;
import edu.stanford.smi.protegex.owl.ui.search.ResourceListFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RestrictionEditorPanel
extends JComponent
implements ModalDialogFactory.CloseCallback {
    private Action createDatatypePropertyAction;
    private Action createObjectPropertyAction;
    private Action createRDFPropertyAction;
    private FillerTextArea fillerTextArea;
    private JList kindList;
    private OWLModel owlModel;
    private JList propertyList;
    private OWLSymbolPanel symbolPanel;
    private RDFSClass targetClass;
    private Action viewAction;
    private static String recentPropertyName;

    public RestrictionEditorPanel(OWLModel owlModel, Cls metaCls, RDFProperty property, String fillerText, RDFSClass targetClass) {
        this.owlModel = owlModel;
        this.targetClass = targetClass;
        this.createActions();
        this.propertyList = ComponentFactory.createList(null);
        this.propertyList.getSelectionModel().setSelectionMode(0);
        this.propertyList.setCellRenderer(FrameRenderer.createInstance());
        this.propertyList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RestrictionEditorPanel.this.changeProperty((RDFProperty)RestrictionEditorPanel.this.propertyList.getSelectedValue());
                RestrictionEditorPanel.this.enableActions();
            }
        });
        this.propertyList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && RestrictionEditorPanel.this.viewAction.isEnabled()) {
                    RestrictionEditorPanel.this.viewAction.actionPerformed(null);
                }
            }
        });
        this.updatePropertiesList();
        JPanel propertyPanel = new JPanel(new BorderLayout());
        propertyPanel.setLayout(new BorderLayout());
        JScrollPane propertyScrollPane = new JScrollPane(this.propertyList);
        propertyScrollPane.setPreferredSize(new Dimension(240, 150));
        propertyPanel.add("Center", propertyScrollPane);
        propertyPanel.add("South", (Component)((Object)new ResourceListFinder(this.propertyList, "Find")));
        Cls[] metaClses = ProfilesManager.getSupportedRestrictionMetaClses(owlModel);
        this.kindList = new JList<Cls>(metaClses);
        this.kindList.setCellRenderer(new RestrictionKindRenderer());
        this.kindList.getSelectionModel().setSelectionMode(0);
        this.kindList.setSelectedValue(metaCls, true);
        JScrollPane kindScrollPane = new JScrollPane(this.kindList);
        kindScrollPane.setPreferredSize(new Dimension(160, 150));
        this.kindList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RestrictionEditorPanel.this.changeKind((Cls)RestrictionEditorPanel.this.kindList.getSelectedValue());
            }
        });
        JPanel kindPanel = new JPanel();
        kindPanel.setLayout(new BorderLayout());
        kindPanel.add("North", (Component)new LabeledComponent("Restriction", kindScrollPane));
        kindPanel.add("Center", new JPanel());
        this.symbolPanel = new OWLSymbolPanel(owlModel, false);
        if (fillerText == null) {
            this.symbolPanel.setErrorFlag(true);
        }
        this.enableSymbolPanel();
        this.fillerTextArea = new FillerTextArea(owlModel, this.symbolPanel);
        this.fillerTextArea.setRestrictionProperty(this.getRestrictionProperty(metaCls));
        if (fillerText != null) {
            this.fillerTextArea.setText(fillerText);
        }
        this.symbolPanel.setSymbolEditor(this.fillerTextArea);
        JPanel fillerPanel = new JPanel(new BorderLayout(4, 4));
        this.fillerTextArea.setPreferredSize(new Dimension(200, 64));
        this.fillerTextArea.setLineWrap(true);
        this.fillerTextArea.setWrapStyleWord(true);
        fillerPanel.add("North", new JScrollPane(this.fillerTextArea));
        fillerPanel.add("Center", this.symbolPanel);
        this.setLayout(new BorderLayout(10, 10));
        LabeledComponent lc = new LabeledComponent("Restricted Property", (Component)propertyPanel);
        if (OWLUtil.hasRDFProfile(owlModel)) {
            lc.addHeaderButton(this.createRDFPropertyAction);
        }
        lc.addHeaderButton(this.createDatatypePropertyAction);
        lc.addHeaderButton(this.createObjectPropertyAction);
        this.add("Center", (Component)lc);
        this.add("East", kindPanel);
        this.add("South", (Component)new LabeledComponent("Filler", (Component)fillerPanel));
        if (property != null) {
            this.propertyList.setSelectedValue(property, true);
        } else if (this.propertyList.getModel().getSize() > 0) {
            this.propertyList.setSelectedIndex(0);
        }
    }

    private void addNewProperty(RDFProperty newProperty) {
        newProperty.setFunctional(false);
        newProperty.setDomainDefined(false);
        this.showModalPropertyWidget(newProperty);
        this.updatePropertiesList();
        this.propertyList.setSelectedValue(newProperty, true);
    }

    public boolean canClose(int result) {
        if (result == 1) {
            RDFProperty selectedProperty = (RDFProperty)this.propertyList.getSelectedValue();
            if (selectedProperty != null) {
                String uniCodeText = this.fillerTextArea.getText();
                if (uniCodeText.length() == 0) {
                    this.symbolPanel.displayError("Please enter a filler");
                    return false;
                }
                try {
                    this.fillerTextArea.checkExpression(uniCodeText);
                    return true;
                }
                catch (Throwable ex) {
                    this.symbolPanel.displayError(ex);
                    return false;
                }
            }
            this.symbolPanel.displayError("Please select a property");
            return false;
        }
        return true;
    }

    private void changeKind(Cls metaclass) {
        this.fillerTextArea.setRestrictionProperty(this.getRestrictionProperty(metaclass));
        this.fillerTextArea.displayError();
        this.enableSymbolPanel();
    }

    private void changeProperty(RDFProperty property) {
        this.fillerTextArea.setOnProperty(property);
        this.fillerTextArea.displayError();
        this.enableSymbolPanel();
        this.fillerTextArea.requestFocus();
        if (property != null) {
            recentPropertyName = property.getName();
        }
    }

    private void createActions() {
        this.viewAction = new AbstractAction("View Property...", OWLIcons.getViewIcon()){

            public void actionPerformed(ActionEvent arg0) {
                RDFProperty property = (RDFProperty)RestrictionEditorPanel.this.propertyList.getSelectedValue();
                RestrictionEditorPanel.this.showModalPropertyWidget(property);
            }
        };
        this.viewAction.setEnabled(false);
        this.createDatatypePropertyAction = new AbstractAction("Create datatype property...", OWLIcons.getCreatePropertyIcon("OWLDatatypeProperty")){

            public void actionPerformed(ActionEvent arg0) {
                OWLDatatypeProperty newProperty = RestrictionEditorPanel.this.owlModel.createOWLDatatypeProperty(null);
                RestrictionEditorPanel.this.addNewProperty(newProperty);
            }
        };
        this.createObjectPropertyAction = new AbstractAction("Create object property...", OWLIcons.getCreatePropertyIcon("OWLObjectProperty")){

            public void actionPerformed(ActionEvent arg0) {
                OWLObjectProperty newProperty = RestrictionEditorPanel.this.owlModel.createOWLObjectProperty(null);
                RestrictionEditorPanel.this.addNewProperty(newProperty);
            }
        };
        this.createRDFPropertyAction = new AbstractAction("Create RDF property...", OWLIcons.getCreatePropertyIcon("RDFProperty")){

            public void actionPerformed(ActionEvent arg0) {
                RDFProperty newProperty = RestrictionEditorPanel.this.owlModel.createRDFProperty(null);
                RestrictionEditorPanel.this.addNewProperty(newProperty);
            }
        };
    }

    private OWLRestriction createRestriction(Cls metaCls, RDFProperty property, String text) throws Exception {
        Collection parents = CollectionUtilities.createCollection((Object)this.owlModel.getCls(":OWL-ANONYMOUS-ROOT"));
        OWLModel kb = this.owlModel;
        OWLRestriction restriction = (OWLRestriction)kb.createCls(null, parents, metaCls);
        restriction.setOnProperty(property);
        restriction.setFillerText(text);
        return restriction;
    }

    private void enableSymbolPanel() {
        Cls metaCls = this.getSelectedMetaCls();
        this.symbolPanel.setEnabled(true);
        this.symbolPanel.enableActions(this.getSelectedProperty(), metaCls);
    }

    private void enableActions() {
        this.viewAction.setEnabled(true);
    }

    OWLRestriction getResult() {
        try {
            String text = this.fillerTextArea.getText();
            return this.createRestriction(this.getSelectedMetaCls(), this.getSelectedProperty(), text);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private RDFProperty getRestrictionProperty(Cls metaCls) {
        if (metaCls.getName().equals("owl:AllValuesFromRestriction")) {
            return this.owlModel.getRDFProperty("owl:allValuesFrom");
        }
        if (metaCls.getName().equals("owl:SomeValuesFromRestriction")) {
            return this.owlModel.getRDFProperty("owl:someValuesFrom");
        }
        if (metaCls.getName().equals("owl:HasValueRestriction")) {
            return this.owlModel.getRDFProperty("owl:hasValue");
        }
        if (metaCls.getName().equals("owl:MaxCardinalityRestriction")) {
            return this.owlModel.getRDFProperty("owl:maxCardinality");
        }
        if (metaCls.getName().equals("owl:MinCardinalityRestriction")) {
            return this.owlModel.getRDFProperty("owl:minCardinality");
        }
        return this.owlModel.getRDFProperty("owl:cardinality");
    }

    Cls getSelectedMetaCls() {
        return (Cls)this.kindList.getSelectedValue();
    }

    RDFProperty getSelectedProperty() {
        return (RDFProperty)this.propertyList.getSelectedValue();
    }

    public static OWLRestriction showCreateDialog(Component parent, RDFSClass targetClass, Cls metaCls, RDFProperty property) {
        return RestrictionEditorPanel.showCreateDialog(parent, targetClass, metaCls, property, null);
    }

    public static OWLRestriction showCreateDialog(Component parent, RDFSClass targetClass, Cls metaCls, RDFProperty property, String fillerText) {
        RDFResource resource;
        OWLModel owlModel = targetClass.getOWLModel();
        if (property == null && recentPropertyName != null && (resource = owlModel.getRDFResource(recentPropertyName)) instanceof RDFProperty) {
            property = (RDFProperty)resource;
        }
        RestrictionEditorPanel panel = new RestrictionEditorPanel(owlModel, metaCls, property, fillerText, targetClass);
        panel.getFillerTextArea().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 10) {
                    ProtegeUI.getModalDialogFactory().attemptDialogClose(1);
                }
            }
        });
        if (ProtegeUI.getModalDialogFactory().showDialog(parent, panel, "Create Restriction", 11, panel) == 1) {
            return panel.getResult();
        }
        return null;
    }

    private FillerTextArea getFillerTextArea() {
        return this.fillerTextArea;
    }

    public static OWLRestriction showCreateDialog(Component parent, RDFSClass targetClass, Cls metaCls) {
        return RestrictionEditorPanel.showCreateDialog(parent, targetClass, metaCls, null);
    }

    private void showModalPropertyWidget(RDFProperty property) {
        ClsWidget widget = this.owlModel.getProject().createRuntimeClsWidget((Instance)property);
        InstanceNameComponent nameComponent = new InstanceNameComponent();
        nameComponent.setInstance(property);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)nameComponent, "North");
        panel.add((Component)((JComponent)widget), "Center");
        ProtegeUI.getModalDialogFactory().showDialog(this, panel, "Property " + property.getBrowserText(), 14);
    }

    private void updatePropertiesList() {
        Collection allProperties = this.owlModel.getVisibleUserDefinedRDFProperties();
        ArrayList<RDFProperty> selectableProperties = new ArrayList<RDFProperty>();
        for (RDFProperty property : allProperties) {
            if (property.isAnnotationProperty()) continue;
            selectableProperties.add(property);
        }
        RDFSNamedClass dbrClass = this.owlModel.getRDFSNamedClass(":DIRECTED-BINARY-RELATION");
        if (this.targetClass != null && this.targetClass.hasSuperclass(dbrClass)) {
            RDFProperty toProperty;
            RDFProperty fromProperty = this.owlModel.getRDFProperty(":FROM");
            if (fromProperty.isVisible()) {
                selectableProperties.add(fromProperty);
            }
            if ((toProperty = this.owlModel.getRDFProperty(":TO")).isVisible()) {
                selectableProperties.add(toProperty);
            }
        }
        Object[] propertiesArray = selectableProperties.toArray();
        Arrays.sort(propertiesArray, new FrameComparator());
        List<Object> propertiesList = Arrays.asList(propertiesArray);
        this.propertyList.setListData(propertiesList.toArray());
    }
}

