/* Generated By:JavaCC: Do not edit this line. ManchesterOWLParser.java */
package edu.stanford.smi.protegex.owl.model.classparser.manchester;

import com.hp.hpl.jena.ontology.OntClass;
import edu.stanford.smi.protege.model.*;
import edu.stanford.smi.protegex.owl.model.*;
import edu.stanford.smi.protegex.owl.model.classparser.DatatypeNameChecker;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;


public class ManchesterOWLParser implements ManchesterOWLParserConstants {

    public static boolean nextCouldBeCls;
    public static boolean nextCouldBeInstance;
    public static boolean nextCouldBeSlot;
    public static RDFProperty recentHasValueProperty;
    public static String errorMessage;
    public static boolean nextCouldBeDatatypeName;

    private static DatatypeNameChecker datatypeNameChecker;

    private OWLModel owlModel;

    private boolean create;

    public static DatatypeNameChecker getDatatypeNameChecker() {
        return datatypeNameChecker;
    }

    private static void createDatatypeNameChecker(OWLModel owlModel) {
        datatypeNameChecker = new DatatypeNameChecker(owlModel);
    }

    public static void checkClass(OWLModel owlModel, String text) throws ParseException {
        reset();
        createDatatypeNameChecker(owlModel);
        ManchesterOWLParser parser = new ManchesterOWLParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        parser.parseFile();
    }


    private void checkFeatureSupported(OntClass ontClass) throws ParseException {
        if (!ProfilesManager.isFeatureSupported(owlModel, ontClass)) {
            String label = ontClass.getLabel(null);
            if (label == null) {
                label = ontClass.getLocalName();
            }
            errorMessage = "Feature \"" + label + "\" unavailable in current language profile";
            throw generateParseException();
        }
    }


    public static void checkHasValueFiller(OWLModel owlModel, String text) throws ParseException {
        reset();
        createDatatypeNameChecker(owlModel);
        ManchesterOWLParser parser = new ManchesterOWLParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        parser.OWLHasValueValue();
    }


    public static void checkQuantifierFiller(OWLModel owlModel, String text) throws ParseException {
        reset();
        createDatatypeNameChecker(owlModel);
        ManchesterOWLParser parser = new ManchesterOWLParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        if (parser.DataType() == null) {
            throw new ParseException("Unknown datatype \"" + text + "\".");
        }
    }


    public static RDFSClass parseClass(OWLModel owlModel, String text) throws ParseException {
        reset();
        createDatatypeNameChecker(owlModel);
        ManchesterOWLParser parser = new ManchesterOWLParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = true;
        return parser.parseFile();
    }


    public static Object parseHasValueFiller(OWLModel owlModel, String text) throws ParseException {
        reset();
        createDatatypeNameChecker(owlModel);
        ManchesterOWLParser parser = new ManchesterOWLParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = true;
        return parser.OWLHasValueValue();
    }


    public static Object parseQuantifierFiller(OWLModel owlModel, String text) throws ParseException {
        reset();
        createDatatypeNameChecker(owlModel);
        ManchesterOWLParser parser = new ManchesterOWLParser(new StringReader(text));
        parser.owlModel = owlModel;
        parser.create = false;
        return parser.DataType();
    }


    private static void reset() {
        nextCouldBeCls = false;
        nextCouldBeSlot = false;
        nextCouldBeInstance = false;
        nextCouldBeDatatypeName = false;
        errorMessage = null;
    }

    final public RDFSClass parseFile() throws ParseException {
        RDFSClass result;
        Token token;
        String comment = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case CLASS_EXPR_COMMENT:
                token = jj_consume_token(CLASS_EXPR_COMMENT);
                comment = token.image;
                break;
            default:
                jj_la1[0] = jj_gen;
                ;
        }
        result = OWLUnionClass();
        if (comment != null && result != null) {
            if (result.isAnonymous() && owlModel.isProtegeMetaOntologyImported()) {
                String propName = ProtegeNames.Slot.IS_COMMENTED_OUT;
                RDFProperty commentProp = owlModel.getRDFProperty(propName);
                if (commentProp != null) {
                    result.setPropertyValue(commentProp, "true");
                }
            }
        }
        {
            if (true) return result;
        }
        jj_consume_token(0);
        throw new Error("Missing return statement in function");
    }

    final public RDFSClass OWLUnionClass() throws ParseException {
        List clses = new ArrayList();
        RDFSClass cls;
        cls = OWLIntersectionClass();
        clses.add(cls);
        label_1:
        while (true) {
            if (jj_2_1(2)) {
                ;
            }
            else {
                break label_1;
            }
            jj_consume_token(OR);
            cls = OWLIntersectionClass();
            clses.add(cls);
        }
        if (clses.size() == 1) {
            {
                if (true) return cls;
            }
        }
        else {
            checkFeatureSupported(OWLProfiles.Union_Classes);
            if (create) {
                {
                    if (true) return owlModel.createOWLUnionClass(clses);
                }
            }
            else {
                {
                    if (true) return null;
                }
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public RDFSClass OWLIntersectionClass() throws ParseException {
        List clses = new ArrayList();
        RDFSClass cls;
        cls = OWLComplementClass();
        clses.add(cls);
        label_2:
        while (true) {
            if (jj_2_2(2)) {
                ;
            }
            else {
                break label_2;
            }
            jj_consume_token(AND);
            cls = OWLComplementClass();
            clses.add(cls);
        }
        if (clses.size() == 1) {
            {
                if (true) return cls;
            }
        }
        else {
            if (create) {
                {
                    if (true) return owlModel.createOWLIntersectionClass(clses);
                }
            }
            else {
                {
                    if (true) return null;
                }
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public RDFSClass OWLComplementClass() throws ParseException {
        RDFSClass cls;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NOT:
                jj_consume_token(NOT);
                cls = OWLRestrictionOrNamedClass();
                checkFeatureSupported(OWLProfiles.Complement_Classes);
                if (create) {
                    {
                        if (true) return owlModel.createOWLComplementClass(cls);
                    }
                }
                else {
                    {
                        if (true) return null;
                    }
                }
                break;
            case OPENPAR:
            case IDENTIFIER:
            case 30:
                cls = OWLRestrictionOrNamedClass();
                break;
            default:
                jj_la1[1] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        {
            if (true) return cls;
        }
        throw new Error("Missing return statement in function");
    }

    final public RDFSClass OWLRestrictionOrNamedClass() throws ParseException {
        RDFSClass cls;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 30:
                cls = OWLEnumeratedClass();
                break;
            case IDENTIFIER:
                cls = IDClass();
                break;
            case OPENPAR:
                jj_consume_token(OPENPAR);
                cls = OWLUnionClass();
                jj_consume_token(CLOSEPAR);
                break;
            default:
                jj_la1[2] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        {
            if (true) return cls;
        }
        throw new Error("Missing return statement in function");
    }

// An artificial concept that branches depending on whether the id is a class
// or a slot name

    final public RDFSClass IDClass() throws ParseException {
        String id;
        id = Identifier();
        Frame frame = ((KnowledgeBase) owlModel).getFrame(id);
        if (frame instanceof RDFSClass) {
            {
                if (true) return (RDFSClass) frame;
            }
        }
        else {
            if (frame instanceof RDFProperty && !((RDFProperty) frame).isAnnotationProperty()) {
                recentHasValueProperty = (RDFProperty) frame;
                {
                    if (true) return Restriction(recentHasValueProperty);
                }
            }
            else {
                nextCouldBeCls = true;
                nextCouldBeSlot = true;
                errorMessage = "Class or property name expected";
                {
                    if (true) throw generateParseException();
                }
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLRestriction Restriction(RDFProperty property) throws ParseException {
        OWLRestriction result;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case MIN:
            case MAX:
            case EXACT:
                result = OWLCardinalityBase(property);
                break;
            case HAS:
                result = OWLHasValue(property);
                break;
            case ALL:
                result = OWLAllValuesFrom(property);
                break;
            case SOME:
                result = OWLSomeValuesFrom(property);
                break;
            default:
                jj_la1[3] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        {
            if (true) return result;
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLCardinalityBase OWLCardinalityBase(RDFProperty property) throws ParseException {
        OWLCardinalityBase result;
        RDFSClass valuesFromClass = null;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case MAX:
                result = OWLMaxCardinality(property);
                break;
            case MIN:
                result = OWLMinCardinality(property);
                break;
            case EXACT:
                result = OWLCardinality(property);
                break;
            default:
                jj_la1[4] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NOT:
            case OPENPAR:
            case IDENTIFIER:
            case 30:
                valuesFromClass = OWLUnionClass();
                break;
            default:
                jj_la1[5] = jj_gen;
                ;
        }
        if (create && valuesFromClass != null) {
            result.setValuesFrom(valuesFromClass);
        }
        {
            if (true) return result;
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLMaxCardinality OWLMaxCardinality(RDFProperty slot) throws ParseException {
        int card;
        jj_consume_token(MAX);
        card = CardinalityValue();
        checkFeatureSupported(OWLProfiles.MaxCardinality_Restrictions);
        if (create) {
            {
                if (true) return owlModel.createOWLMaxCardinality(slot, card);
            }
        }
        else {
            {
                if (true) return null;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLMinCardinality OWLMinCardinality(RDFProperty slot) throws ParseException {
        int card;
        jj_consume_token(MIN);
        card = CardinalityValue();
        checkFeatureSupported(OWLProfiles.MinCardinality_Restrictions);
        if (create) {
            {
                if (true) return owlModel.createOWLMinCardinality(slot, card);
            }
        }
        else {
            {
                if (true) return null;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLCardinality OWLCardinality(RDFProperty slot) throws ParseException {
        int card;
        jj_consume_token(EXACT);
        card = CardinalityValue();
        checkFeatureSupported(OWLProfiles.MinCardinality_Restrictions);
        checkFeatureSupported(OWLProfiles.MaxCardinality_Restrictions);
        if (create) {
            {
                if (true) return owlModel.createOWLCardinality(slot, card);
            }
        }
        else {
            {
                if (true) return null;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLHasValue OWLHasValue(RDFProperty slot) throws ParseException {
        Object value;
        jj_consume_token(HAS);
        value = OWLHasValueValue();
        checkFeatureSupported(OWLProfiles.HasValue_Restrictions);
        if (!(slot instanceof OWLDatatypeProperty)) {
            if (OWLUtil.hasOWLDLProfile(owlModel) && (value instanceof Cls || value instanceof Slot)) {
                value = null;
            }
            if (!(value instanceof Instance)) {
                nextCouldBeInstance = true;
                if (OWLUtil.hasOWLFullProfile(owlModel)) {
                    nextCouldBeSlot = true;
                    nextCouldBeCls = true;
                    errorMessage = "Individual, class or property expected";
                }
                else {
                    errorMessage = "Individual expected (in OWL DL)";
                }
                {
                    if (true) throw generateParseException();
                }
            }
        }
        else if (slot instanceof OWLDatatypeProperty && value instanceof Instance) {
            errorMessage = "Datatype literal expected";
            {
                if (true) throw generateParseException();
            }
        }
        if (create) {
            {
                if (true) return owlModel.createOWLHasValue(slot, value);
            }
        }
        else {
            {
                if (true) return null;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Object OWLHasValueValueAndEOF() throws ParseException {
        Object result;
        result = OWLHasValueValue();
        jj_consume_token(0);
        {
            if (true) return result;
        }
        throw new Error("Missing return statement in function");
    }

    final public Object OWLHasValueValue() throws ParseException {
        Object result;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case STRING_LITERAL:
                result = OWLHasValueValueString();
                break;
            case FLOATING_POINT_LITERAL:
                result = OWLHasValueValueFloat();
                break;
            case INTEGER_LITERAL:
                result = OWLHasValueValueInteger();
                break;
            case IDENTIFIER:
                result = OWLHasValueValueBooleanOrInstance();
                break;
            default:
                jj_la1[6] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        {
            if (true) return result;
        }
        throw new Error("Missing return statement in function");
    }

    final public String OWLHasValueValueString() throws ParseException {
        Token token;
        token = jj_consume_token(STRING_LITERAL);
        String str = token.image;
        int len = str.length();
        {
            if (true) return str.substring(1, len - 1);
        }
        throw new Error("Missing return statement in function");
    }

    final public Float OWLHasValueValueFloat() throws ParseException {
        Token token;
        token = jj_consume_token(FLOATING_POINT_LITERAL);
        {
            if (true) return Float.valueOf(token.image);
        }
        throw new Error("Missing return statement in function");
    }

    final public Integer OWLHasValueValueInteger() throws ParseException {
        Token token;
        token = jj_consume_token(INTEGER_LITERAL);
        {
            if (true) return Integer.valueOf(token.image);
        }
        throw new Error("Missing return statement in function");
    }

    final public Object OWLHasValueValueBooleanOrInstance() throws ParseException {
        String id;
        id = Identifier();
        if (id.equals("true")) {
            {
                if (true) return Boolean.TRUE;
            }
        }
        else if (id.equals("false")) {
            {
                if (true) return Boolean.FALSE;
            }
        }
        else {
            RDFResource instance = owlModel.getRDFResourceByNameOrBrowserText(id);
            if (instance == null) {
                nextCouldBeInstance = true;
                nextCouldBeSlot = true;
                nextCouldBeCls = true;
                errorMessage = "Instance or datatype literal expected";
                {
                    if (true) throw generateParseException();
                }
            }
            {
                if (true) return instance;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public int CardinalityValue() throws ParseException {
        Token token;
        token = jj_consume_token(INTEGER_LITERAL);
        int value = Integer.parseInt(token.image);
        if (value >= 0) {
            {
                if (true) return value;
            }
        }
        else {
            {
                if (true) throw generateParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public String Identifier() throws ParseException {
        Token t;
        t = jj_consume_token(IDENTIFIER);
        {
            if (true) return t.image;
        }
        throw new Error("Missing return statement in function");
    }

    final public RDFSClass OWLEnumeratedClass() throws ParseException {
        Collection values = new ArrayList();
        String instanceText;
        jj_consume_token(30);
        label_3:
        while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case IDENTIFIER:
                    ;
                    break;
                default:
                    jj_la1[7] = jj_gen;
                    break label_3;
            }
            instanceText = Identifier();
            Instance instance = owlModel.getRDFResourceByNameOrBrowserText(instanceText);
            if (OWLUtil.hasOWLDLProfile(owlModel) && (instance instanceof Cls || instance instanceof Slot)) {
                instance = null;
            }
            if (instance == null) {
                nextCouldBeInstance = true;
                if (OWLUtil.hasOWLFullProfile(owlModel)) {
                    nextCouldBeCls = true;
                    nextCouldBeSlot = true;
                    errorMessage = "Name of an individual, class or property expected";
                }
                else {
                    errorMessage = "Name of an individual expected (in OWL DL)";
                }
                {
                    if (true) throw generateParseException();
                }
            }
            values.add(instance);
        }
        jj_consume_token(31);
        checkFeatureSupported(OWLProfiles.Enumerated_Classes);
        if (create) {
            {
                if (true) return owlModel.createOWLEnumeratedClass(values);
            }
        }
        else {
            {
                if (true) return null;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLAllValuesFrom OWLAllValuesFrom(RDFProperty property) throws ParseException {
        RDFSClass allCls;
        Object valueType;
        jj_consume_token(ALL);
        checkFeatureSupported(OWLProfiles.AllValuesFrom_Restrictions);
        valueType = DataType();
        if (valueType instanceof RDFSClass || valueType == ValueType.INSTANCE) {
            if (property instanceof OWLDatatypeProperty) {
                errorMessage = "owl:ObjectProperty or rdf:Property expected";
                {
                    if (true) throw generateParseException();
                }
            }
            if (create) {
                {
                    if (true) return owlModel.createOWLAllValuesFrom(property, (RDFSClass) valueType);
                }
            }
            else {
                {
                    if (true) return null;
                }
            }
        }

        if (valueType == null) {
            errorMessage = "XML Schema datatype expected";
            {
                if (true) throw generateParseException();
            }
        }

        if (!(property instanceof OWLDatatypeProperty)) {
            errorMessage = "owl:DatatypeProperty expected";
            {
                if (true) throw generateParseException();
            }
        }
        if (create) {
            if (valueType instanceof RDFSDatatype) {
                {
                    if (true) return owlModel.createOWLAllValuesFrom(property, (RDFSDatatype) valueType);
                }
            }
            else {
                {
                    if (true) return owlModel.createOWLAllValuesFrom(property, (RDFSLiteral[]) valueType);
                }
            }
        }
        else {
            {
                if (true) return null;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public OWLSomeValuesFrom OWLSomeValuesFrom(RDFProperty property) throws ParseException {
        RDFSClass someCls;
        Object valueType;
        jj_consume_token(SOME);
        checkFeatureSupported(OWLProfiles.SomeValuesFrom_Restrictions);
        valueType = DataType();
        if (valueType instanceof RDFSClass || valueType == ValueType.INSTANCE) {
            if (property instanceof OWLDatatypeProperty) {
                errorMessage = "owl:ObjectProperty or rdf:Property expected";
                {
                    if (true) throw generateParseException();
                }
            }
            if (create) {
                {
                    if (true) return owlModel.createOWLSomeValuesFrom(property, (RDFSClass) valueType);
                }
            }
            else {
                {
                    if (true) return null;
                }
            }
        }
        else if (!(property instanceof OWLDatatypeProperty)) {
            errorMessage = "owl:DatatypeProperty expected";
            {
                if (true) throw generateParseException();
            }
        }
        if (valueType == null) {
            errorMessage = "XML Schema datatype expected";
            {
                if (true) throw generateParseException();
            }
        }
        if (create) {
            if (valueType instanceof RDFSDatatype) {
                {
                    if (true) return owlModel.createOWLSomeValuesFrom(property, (RDFSDatatype) valueType);
                }
            }
            else {
                {
                    if (true) return owlModel.createOWLSomeValuesFrom(property, (RDFSLiteral[]) valueType);
                }
            }
        }
        else {
            {
                if (true) return null;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Object DataType() throws ParseException {
        RDFSLiteral[] oneOfValues = null;
        Object cl = null;
        RDFSDatatype datatype;
        boolean userDerived = false;
        RDFProperty minProp = null;
        RDFProperty maxProp = null;
        String minVal = null;
        String maxVal = null;
        nextCouldBeDatatypeName = true;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case ONE_OF:
                jj_consume_token(ONE_OF);
                oneOfValues = OneOfValues();
            {
                if (true) return oneOfValues;
            }
            break;
            case DATATYPEID:
                token = jj_consume_token(DATATYPEID);
                String qName = datatypeNameChecker.getDatatypeQName(token.image);
                datatype = owlModel.getRDFSDatatypeByName(qName);
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case OPENPAR:
                    case OPENSQPAR:
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case OPENPAR:
                                token = jj_consume_token(OPENPAR);
                                minProp = XSPNames.getRDFProperty(owlModel, XSPNames.XSP_MIN_EXCLUSIVE);
                                break;
                            case OPENSQPAR:
                                token = jj_consume_token(OPENSQPAR);
                                minProp = XSPNames.getRDFProperty(owlModel, XSPNames.XSP_MIN_INCLUSIVE);
                                break;
                            default:
                                jj_la1[8] = jj_gen;
                                jj_consume_token(-1);
                                throw new ParseException();
                        }
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case UNBOUNDEDVAL:
                            case INTEGER_LITERAL:
                            case FLOATING_POINT_LITERAL:
                                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                    case INTEGER_LITERAL:
                                        token = jj_consume_token(INTEGER_LITERAL);
                                        minVal = token.image;
                                        break;
                                    case FLOATING_POINT_LITERAL:
                                        token = jj_consume_token(FLOATING_POINT_LITERAL);
                                        minVal = token.image;
                                        break;
                                    case UNBOUNDEDVAL:
                                        jj_consume_token(UNBOUNDEDVAL);
                                        break;
                                    default:
                                        jj_la1[9] = jj_gen;
                                        jj_consume_token(-1);
                                        throw new ParseException();
                                }
                                break;
                            default:
                                jj_la1[10] = jj_gen;
                                ;
                        }
                        jj_consume_token(32);
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case UNBOUNDEDVAL:
                            case INTEGER_LITERAL:
                            case FLOATING_POINT_LITERAL:
                                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                                    case INTEGER_LITERAL:
                                        token = jj_consume_token(INTEGER_LITERAL);
                                        maxVal = token.image;
                                        break;
                                    case FLOATING_POINT_LITERAL:
                                        token = jj_consume_token(FLOATING_POINT_LITERAL);
                                        maxVal = token.image;
                                        break;
                                    case UNBOUNDEDVAL:
                                        jj_consume_token(UNBOUNDEDVAL);
                                        break;
                                    default:
                                        jj_la1[11] = jj_gen;
                                        jj_consume_token(-1);
                                        throw new ParseException();
                                }
                                break;
                            default:
                                jj_la1[12] = jj_gen;
                                ;
                        }
                        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                            case CLOSEPAR:
                                token = jj_consume_token(CLOSEPAR);
                                maxProp = XSPNames.getRDFProperty(owlModel, XSPNames.XSP_MAX_EXCLUSIVE);
                                break;
                            case CLOSESQPAR:
                                token = jj_consume_token(CLOSESQPAR);
                                maxProp = XSPNames.getRDFProperty(owlModel, XSPNames.XSP_MAX_INCLUSIVE);
                                break;
                            default:
                                jj_la1[13] = jj_gen;
                                jj_consume_token(-1);
                                throw new ParseException();
                        }
                        userDerived = true;
                        //System.out.println("User defined:");
                        //System.out.println("Min prop: " + minProp);
                        //System.out.println("Max prop: " + maxProp);
                        //System.out.println("Min val: " + minVal);
                        //System.out.println("Max val: " + maxVal);

                        break;
                    default:
                        jj_la1[14] = jj_gen;
                        ;
                }
                if (userDerived == false) {
                    {
                        if (true) return datatype;
                    }
                }
                else {
                    if (create) {
                        RDFSDatatype udd = owlModel.createRDFSDatatype(owlModel.getNextAnonymousResourceName());
                        udd.setPropertyValue(XSPNames.getRDFProperty(owlModel, XSPNames.XSP_BASE), datatype);
                        if (minProp != null && minVal != null) {
                            udd.setPropertyValue(minProp, owlModel.createRDFSLiteral(minVal, datatype));
                        }
                        if (maxProp != null && maxVal != null) {
                            udd.setPropertyValue(maxProp, owlModel.createRDFSLiteral(maxVal, datatype));
                        }
                        {
                            if (true) return udd;
                        }
                    }
                    else {
                        {
                            if (true) return datatype;
                        }
                    }
                }
                break;
            case NOT:
            case OPENPAR:
            case IDENTIFIER:
            case 30:
                cl = OWLComplementClass();
                if (create) {
                    {
                        if (true) return cl;
                    }
                }
                else {
                    {
                        if (true) return ValueType.INSTANCE;
                    }
                }
                break;
            default:
                jj_la1[15] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public RDFSLiteral[] OneOfValues() throws ParseException {
        Collection result = new ArrayList();
        Token token = null;
        Object numberValue = null;
        label_4:
        while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case INTEGER_LITERAL:
                case FLOATING_POINT_LITERAL:
                case STRING_LITERAL:
                    ;
                    break;
                default:
                    jj_la1[16] = jj_gen;
                    break label_4;
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case STRING_LITERAL:
                    token = jj_consume_token(STRING_LITERAL);
                    String str = token.image;
                    int len = str.length();
                    result.add(owlModel.createRDFSLiteral(str.substring(1, len - 1)));
                    break;
                case INTEGER_LITERAL:
                    numberValue = OWLHasValueValueInteger();
                    result.add(owlModel.createRDFSLiteral(numberValue));
                    break;
                case FLOATING_POINT_LITERAL:
                    numberValue = OWLHasValueValueFloat();
                    result.add(owlModel.createRDFSLiteral(numberValue));
                    break;
                default:
                    jj_la1[17] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        jj_consume_token(31);
        {
            if (true) return (RDFSLiteral[]) result.toArray(new RDFSLiteral[0]);
        }
        throw new Error("Missing return statement in function");
    }

    final private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(0, xla);
        }
    }

    final private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(1, xla);
        }
    }

    final private boolean jj_3R_12() {
        if (jj_scan_token(OPENPAR)) return true;
        return false;
    }

    final private boolean jj_3R_11() {
        if (jj_3R_14()) return true;
        return false;
    }

    final private boolean jj_3R_10() {
        if (jj_3R_13()) return true;
        return false;
    }

    final private boolean jj_3R_13() {
        if (jj_scan_token(30)) return true;
        return false;
    }

    final private boolean jj_3R_7() {
        if (jj_scan_token(NOT)) return true;
        return false;
    }

    final private boolean jj_3R_9() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_10()) {
            jj_scanpos = xsp;
            if (jj_3R_11()) {
                jj_scanpos = xsp;
                if (jj_3R_12()) return true;
            }
        }
        return false;
    }

    final private boolean jj_3R_5() {
        if (jj_3R_6()) return true;
        return false;
    }

    final private boolean jj_3R_6() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_7()) {
            jj_scanpos = xsp;
            if (jj_3R_8()) return true;
        }
        return false;
    }

    final private boolean jj_3_1() {
        if (jj_scan_token(OR)) return true;
        if (jj_3R_5()) return true;
        return false;
    }

    final private boolean jj_3_2() {
        if (jj_scan_token(AND)) return true;
        if (jj_3R_6()) return true;
        return false;
    }

    final private boolean jj_3R_14() {
        if (jj_3R_15()) return true;
        return false;
    }

    final private boolean jj_3R_15() {
        if (jj_scan_token(IDENTIFIER)) return true;
        return false;
    }

    final private boolean jj_3R_8() {
        if (jj_3R_9()) return true;
        return false;
    }

    public ManchesterOWLParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token, jj_nt;
    private int jj_ntk;
    private Token jj_scanpos, jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    final private int[] jj_la1 = new int[18];
    static private int[] jj_la1_0;
    static private int[] jj_la1_1;

    static {
        jj_la1_0();
        jj_la1_1();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x100000, 0x4400c000, 0x44008000, 0xfc0, 0xe00, 0x4400c000, 0x5600000, 0x4000000, 0x28000, 0x680000, 0x680000, 0x680000, 0x680000, 0x50000, 0x28000, 0x4e00c000, 0x1600000, 0x1600000,};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,};
    }

    final private JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;

    public ManchesterOWLParser(java.io.InputStream stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new ManchesterOWLParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 18; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(java.io.InputStream stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 18; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public ManchesterOWLParser(java.io.Reader stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new ManchesterOWLParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 18; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 18; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public ManchesterOWLParser(ManchesterOWLParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 18; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(ManchesterOWLParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 18; i++) jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
    }

    final private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) token = token.next;
        else token = token.next = token_source.getNextToken();
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) c.first = null;
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    static private final class LookaheadSuccess extends java.lang.Error {

    }

    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    final private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
            }
            else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        }
        else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) jj_add_error_token(kind, i);
        }
        if (jj_scanpos.kind != kind) return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
        return false;
    }

    final public Token getNextToken() {
        if (token.next != null) token = token.next;
        else token = token.next = token_source.getNextToken();
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    final public Token getToken(int index) {
        Token t = lookingAhead ? jj_scanpos : token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) t = t.next;
            else t = t.next = token_source.getNextToken();
        }
        return t;
    }

    final private int jj_ntk() {
        if ((jj_nt = token.next) == null)
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        else
            return (jj_ntk = jj_nt.kind);
    }

    private java.util.Vector jj_expentries = new java.util.Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) return;
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        }
        else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            boolean exists = false;
            for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
                int[] oldentry = (int[]) (e.nextElement());
                if (oldentry.length == jj_expentry.length) {
                    exists = true;
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            exists = false;
                            break;
                        }
                    }
                    if (exists) break;
                }
            }
            if (!exists) jj_expentries.addElement(jj_expentry);
            if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
        }
    }

    public ParseException generateParseException() {
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[33];
        for (int i = 0; i < 33; i++) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 18; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & (1 << j)) != 0) {
                        la1tokens[32 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 33; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.addElement(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = (int[]) jj_expentries.elementAt(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    final public void enable_tracing() {
    }

    final public void disable_tracing() {
    }

    final private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 2; i++) {
            JJCalls p = jj_2_rtns[i];
            do {
                if (p.gen > jj_gen) {
                    jj_la = p.arg;
                    jj_lastpos = jj_scanpos = p.first;
                    switch (i) {
                        case 0:
                            jj_3_1();
                            break;
                        case 1:
                            jj_3_2();
                            break;
                    }
                }
                p = p.next;
            }
            while (p != null);
        }
        jj_rescan = false;
    }

    final private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {

        int gen;
        Token first;
        int arg;
        JJCalls next;
    }

}
