package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;

import javax.swing.*;
import java.awt.*;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * @author Holger Knublauch  <holger@knublauch.com>
 */
public class TimePanel extends JPanel {

    private Listener listener;

    private JTextField hoursField;

    private JTextField minutesField;

    private JTextField secondsField;


    public TimePanel(Listener listener) {
        this.listener = listener;
        hoursField = new JTextField(2);
        minutesField = new JTextField(2);
        secondsField = new JTextField(2);
        FocusListener focusListener = new FocusListener() {
            public void focusGained(FocusEvent e) {
            }


            public void focusLost(FocusEvent e) {
                notifyListener();
            }
        };
        hoursField.addFocusListener(focusListener);
        minutesField.addFocusListener(focusListener);
        secondsField.addFocusListener(focusListener);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, BoxLayout.X_AXIS));
        leftPanel.add(hoursField);
        leftPanel.add(new JLabel(":"));
        leftPanel.add(minutesField);
        leftPanel.add(new JLabel(":"));
        leftPanel.add(secondsField);
        setLayout(new BorderLayout());
        add(BorderLayout.WEST, leftPanel);
        add(BorderLayout.CENTER, Box.createHorizontalGlue());
    }


    public void clear() {
        hoursField.setText("");
        minutesField.setText("");
        secondsField.setText("");
    }


    private int getInt(JTextField textField, int max) {
        String str = textField.getText();
        return getInt(str, max);
    }


    private int getInt(String str, int max) {
        try {
            int value = Integer.parseInt(str);
            if (value >= 0 && value < max) {
                return value;
            }
        }
        catch (Exception ex) {
        }
        return 0;
    }


    private String getString(int x) {
        if (x < 10) {
            return "0" + x;
        }
        else {
            return "" + x;
        }
    }


    public String getTime() {
        int hours = getInt(hoursField, 24);
        int minutes = getInt(minutesField, 60);
        int seconds = getInt(secondsField, 60);
        return XMLSchemaDatatypes.getTimeString(hours, minutes, seconds);
    }


    public boolean isNull() {
        return hoursField.getText().length() +
                minutesField.getText().length() +
                secondsField.getText().length() == 0;
    }


    private void notifyListener() {
        if (listener != null) {
            listener.timeChanged(this);
        }
    }


    public void setTime(Date date) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(date);
        setTime(cal.get(Calendar.HOUR_OF_DAY), cal.get(Calendar.MINUTE), cal.get(Calendar.SECOND));
    }


    public void setTime(String literal) {
        String[] ss = literal.split(":");
        int hours = ss.length > 0 ? getInt(ss[0], 24) : 0;
        int minutes = ss.length > 1 ? getInt(ss[1], 60) : 0;
        int seconds = ss.length > 2 ? getInt(ss[2], 60) : 0;
        setTime(hours, minutes, seconds);
    }


    public void setTime(int hours, int minutes, int seconds) {
        hoursField.setText("" + getString(hours));
        minutesField.setText("" + getString(minutes));
        secondsField.setText("" + getString(seconds));
    }


    public static interface Listener {

        void timeChanged(TimePanel timePanel);
    }
}
