/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.publish.uddi;

/**
 * This enum holds frequently used tModel information.
 * 
 * @author tilmann
 * 
 */
public enum UddiTModels {
	/**
	 * The UDDI types tModel
	 */
	TYPES("uddi-org:types", "uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4"),

	/**
	 * The tModel for storing the service profile referneces. The key is unknown
	 * and retrieved from UDDI.
	 */
	SERVICE_PROFILE("cmtm-uka-de:ServiceProfile", null);

	/**
	 * The name of the tModel
	 */
	private String name;

	/**
	 * The key of the tModel
	 */
	private String key;

	/**
	 * Create a new tModel
	 * 
	 * @param name
	 *            the name of the tModel
	 * @param key
	 *            the key of the tModel
	 */
	private UddiTModels(String name, String key) {
		this.name = name;
		this.key = key;
	}

	/**
	 * @return the key
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

}
