/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

/**
 * ServiceLocator demo class.
 * 
 * @author tilmann
 */
public class Demo {
	
	/**
	 * Entry point.
	 * @param args the command line arguments
	 * @throws Exception
	 */
	public static void main(String... args) throws Exception {
		
		ServiceLocatorFactory locatorFactory = new ServiceLocatorFactory();
		locatorFactory.setUddiInquiryUrl("http://localhost:8000/juddi/inquiry");
		locatorFactory.setTopOntologyUrl("http://localhost/ontologies/top.owl");
		locatorFactory.setUpperServiceOntologyUrl("http://localhost/ontologies/upperService.owl");
		locatorFactory.setServiceOntologyUrl("http://localhost/ontologies/serviceProfile.owl");
		locatorFactory.setDigReasonerUrl("http://localhost:8080");

		ServiceLocator locator = locatorFactory.createServiceLocator();

		locator
				.addServiceLocatorEventListener(new ServiceLocatorEventListener() {

					public void classNotFound(ClassNotFoundEvent e) {
						System.out.println("WARNING: Class not found: "
								+ e.getClassName());

					}
				});

		ServiceParameter param = new ServiceParameter();

//		param.setCategory("PublishingService");
//		param.setUserRolesCsv("Author");
//		param.setLogicalInputsCsv("LDoc, PublishingArea");
//		param.setLogicalOutputsCsv("Wurst");
//		param.setPreconditionsCsv("Available");
//		param.setEffectsCsv("Published");
//		param.setBusinessName("");
		
		param.setCategory("ServiceProfile");
		param.setUserRolesCsv("");
		param.setLogicalInputsCsv("");
		param.setLogicalOutputsCsv("");
		param.setPreconditionsCsv("");
		param.setEffectsCsv("");
		param.setBusinessName("");

		locator.findServices(param);
	}

 

}
