/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.util.ArrayList;
import java.util.List;

/**
 * This class describes the search parameters for service profiles used by
 * ServiceProfileLocator.
 * 
 * @author tilmann
 */
public class ServiceProfileParameter implements Cloneable {

	private List<String> logicalInputs;

	private List<String> logicalOutputs;

	private List<String> preconditions;

	private List<String> effects;

	private List<String> userRoles;

	private String category;

	/**
	 * @return Returns the userRoles.
	 */
	public List<String> getUserRoles() {
		return userRoles;
	}

	/**
	 * @return Returns the userRoles as comma seperated list.
	 */
	public String getUserRolesCsv() {
		if (userRoles == null)
			return "";
		StringBuilder sb = new StringBuilder();
		if (userRoles.size() > 0)
			sb.append(userRoles.get(0));
		for (int i = 1; i < userRoles.size(); i++)
			sb.append(", ").append(userRoles.get(i));
		return sb.toString();
	}

	/**
	 * @param userRoles
	 *            The userRoles to set.
	 */
	public void setUserRoles(List<String> userRoles) {
		this.userRoles = userRoles;
	}

	/**
	 * @param userRoles
	 *            The userRoles to set as comma seperated list.
	 */
	public void setUserRolesCsv(String userRoles) {
		String[] split = userRoles.replaceAll("\\s", "").split(",");
		this.userRoles = new ArrayList<String>(split.length);
		for (String part : split)
			if (!"".equals(part))
				this.userRoles.add(part);
	}

	/**
	 * @return Returns the effects.
	 */
	public List<String> getEffects() {
		return effects;
	}

	/**
	 * @return Returns the effects as comma seperated list.
	 */
	public String getEffectsCsv() {
		if (effects == null)
			return "";
		StringBuilder sb = new StringBuilder();
		if (effects.size() > 0)
			sb.append(effects.get(0));
		for (int i = 1; i < effects.size(); i++)
			sb.append(", ").append(effects.get(i));
		return sb.toString();
	}

	/**
	 * @param effects
	 *            The effects to set.
	 */
	public void setEffects(List<String> effects) {
		this.effects = effects;
	}

	/**
	 * @param effects
	 *            The effects to set as comma seperated list.
	 */
	public void setEffectsCsv(String effects) {
		String[] split = effects.replaceAll("\\s", "").split(",");
		this.effects = new ArrayList<String>(split.length);
		for (String part : split)
			if (!"".equals(part))
				this.effects.add(part);
	}

	/**
	 * @return Returns the logicalInputs.
	 */
	public List<String> getLogicalInputs() {
		return logicalInputs;
	}

	/**
	 * @return Returns the logicalInputs as comma seperated list.
	 */
	public String getLogicalInputsCsv() {
		if (logicalInputs == null)
			return "";
		StringBuilder sb = new StringBuilder();
		if (logicalInputs.size() > 0)
			sb.append(logicalInputs.get(0));
		for (int i = 1; i < logicalInputs.size(); i++)
			sb.append(", ").append(logicalInputs.get(i));
		return sb.toString();
	}

	/**
	 * @param logicalInputs
	 *            The logicalInputs to set.
	 */
	public void setLogicalInputs(List<String> logicalInputs) {
		this.logicalInputs = logicalInputs;
	}

	/**
	 * @param logicalInputs
	 *            The logicalInputs to set as comma seperated list.
	 */
	public void setLogicalInputsCsv(String logicalInputs) {
		String[] split = logicalInputs.replaceAll("\\s", "").split(",");
		this.logicalInputs = new ArrayList<String>(split.length);
		for (String part : split)
			if (!"".equals(part))
				this.logicalInputs.add(part);
	}

	/**
	 * @return Returns the logicalOutputs.
	 */
	public List<String> getLogicalOutputs() {
		return logicalOutputs;
	}

	/**
	 * @return Returns the logicalOutputs as comma seperated list.
	 */
	public String getLogicalOutputsCsv() {
		if (logicalOutputs == null)
			return "";
		StringBuilder sb = new StringBuilder();
		if (logicalOutputs.size() > 0)
			sb.append(logicalOutputs.get(0));
		for (int i = 1; i < logicalOutputs.size(); i++)
			sb.append(", ").append(logicalOutputs.get(i));
		return sb.toString();
	}

	/**
	 * @param logicalOutputs
	 *            The logicalOutputs to set.
	 */
	public void setLogicalOutputs(List<String> logicalOutputs) {
		this.logicalOutputs = logicalOutputs;
	}

	/**
	 * @param logicalOutputs
	 *            The logicalOutputs to set as comma seperated list.
	 */
	public void setLogicalOutputsCsv(String logicalOutputs) {
		String[] split = logicalOutputs.replaceAll("\\s", "").split(",");
		this.logicalOutputs = new ArrayList<String>(split.length);
		for (String part : split)
			if (!"".equals(part))
				this.logicalOutputs.add(part);
	}

	/**
	 * @return Returns the preconditions.
	 */
	public List<String> getPreconditions() {
		return preconditions;
	}

	/**
	 * @return Returns the preconditions as comma seperated list.
	 */
	public String getPreconditionsCsv() {
		if (preconditions == null)
			return "";
		StringBuilder sb = new StringBuilder();
		if (preconditions.size() > 0)
			sb.append(preconditions.get(0));
		for (int i = 1; i < preconditions.size(); i++)
			sb.append(", ").append(preconditions.get(i));
		return sb.toString();
	}

	/**
	 * @param preconditions
	 *            The preconditions to set.
	 */
	public void setPreconditions(List<String> preconditions) {
		this.preconditions = preconditions;
	}

	/**
	 * @param preconditions
	 *            The preconditions to set as comma seperated list.
	 */
	public void setPreconditionsCsv(String preconditions) {
		String[] split = preconditions.replaceAll("\\s", "").split(",");
		this.preconditions = new ArrayList<String>(split.length);
		for (String part : split)
			if (!"".equals(part))
				this.preconditions.add(part);
	}

	/**
	 * @return Returns the category.
	 */
	public String getCategory() {
		return category;
	}

	/**
	 * @param category
	 *            The category to set.
	 */
	public void setCategory(String category) {
		this.category = category;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("Category: ").append(getCategory()).append("\nUserRoles: ").append(
				getUserRolesCsv()).append("\nPreconditions: ").append(
				getPreconditionsCsv()).append("\nEffects: ").append(
				getEffectsCsv()).append("\nLogicalInputs: ").append(
				getLogicalInputsCsv()).append("\nLogicalOutputs: ").append(
				getLogicalOutputsCsv()).append("\n");
		return sb.toString();
	}

	@Override
	public ServiceProfileParameter clone() {
		try {
			return (ServiceProfileParameter) super.clone();
		} catch (CloneNotSupportedException e) {
			// This should never happen
			e.printStackTrace();
		}
		return null;
	}

}
