/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query.protege;

/**
 * Instances of this interface can be used to calculate relevance of search
 * results.
 * 
 * @author tilmann
 */
public interface RelevanceCalculator {

	/**
	 * Calculates the relevance of the search result info regarding the given
	 * search parameter and conform classes
	 * 
	 * @param info
	 *            the search result
	 * @param parameter
	 *            the search parameter
	 * @param conformClasses
	 *            the conform classes
	 * @return the relevance of the result-parameter-set
	 */
	public double calculateRelevance(ProfileIndividualInfo info,
			ProfileIndividualParameter parameter,
			ParameterConformClasses conformClasses);

}
