/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.query;

import de.uka.cmtm.serviceregistry.query.ServiceInfo;
import de.uka.cmtm.serviceregistry.query.ServiceInstanceInfo;
import de.uka.cmtm.serviceregistry.query.ServiceInstanceLocator;
import de.uka.cmtm.serviceregistry.query.ServiceInstanceParameter;
import de.uka.cmtm.serviceregistry.query.ServiceLocator;
import de.uka.cmtm.serviceregistry.query.ServiceLocatorEventListener;
import de.uka.cmtm.serviceregistry.query.ServiceParameter;
import de.uka.cmtm.serviceregistry.query.ServiceProfileInfo;
import de.uka.cmtm.serviceregistry.query.ServiceProfileLocator;
import de.uka.cmtm.serviceregistry.query.ServiceProfileParameter;
import de.uka.cmtm.serviceregistry.query.protege.ProtegeServiceProfileLocator;
import de.uka.cmtm.serviceregistry.query.uddi.UddiServiceInstanceLocatorV01_08;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.uddi4j.client.UDDIProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceLocator
implements ServiceLocator {
    private static final Log log = LogFactory.getLog(DefaultServiceLocator.class);
    private ServiceInstanceLocator serviceInstanceLocator;
    private ServiceProfileLocator serviceProfileLocator;

    public DefaultServiceLocator(String uddiInquiryUrl, String digReasonerUrl, String serviceOntologyUrl, String upperServiceOntologyUrl, String topOntologyUrl) throws InstantiationException {
        UDDIProxy uddiProxy;
        this.serviceProfileLocator = new ProtegeServiceProfileLocator(digReasonerUrl, serviceOntologyUrl, upperServiceOntologyUrl, topOntologyUrl);
        try {
            uddiProxy = new UDDIProxy(new URL(uddiInquiryUrl), null);
        }
        catch (MalformedURLException e) {
            IllegalArgumentException ie = new IllegalArgumentException("Malformed uddiInquiryUrl: " + uddiInquiryUrl);
            ie.initCause(e);
            throw ie;
        }
        this.serviceInstanceLocator = new UddiServiceInstanceLocatorV01_08(uddiProxy);
    }

    @Override
    public List<ServiceInfo> findServices(ServiceParameter searchParameter) throws IOException {
        StringBuilder sb;
        if (log.isDebugEnabled()) {
            log.debug((Object)("findServices invoced for search parameter:\n" + searchParameter.toString()));
        }
        LinkedList<ServiceInfo> resultingServices = new LinkedList<ServiceInfo>();
        ServiceProfileParameter profileParameter = searchParameter.getProfileParameter();
        ServiceInstanceParameter instanceParameter = searchParameter.getInstanceParameter().clone();
        int searchLevel = 0;
        int availableSearchLevels = this.serviceProfileLocator.getAvailableSearchLevels();
        this.serviceProfileLocator.setServiceProfileParameter(profileParameter);
        while (resultingServices.isEmpty() && searchLevel < availableSearchLevels) {
            List<ServiceProfileInfo> profiles = this.serviceProfileLocator.findServiceProfiles(searchLevel);
            log.debug((Object)("Found " + profiles.size() + " service profiles with searchLevel " + searchLevel));
            for (ServiceProfileInfo profile : profiles) {
                instanceParameter.setProfileUri(profile.getProfileUri());
                List<ServiceInstanceInfo> instances = this.serviceInstanceLocator.findSeviceInstances(instanceParameter);
                log.debug((Object)("Found " + instances.size() + " service instances of profile " + profile.getProfileUri()));
                for (ServiceInstanceInfo instance : instances) {
                    resultingServices.add(new ServiceInfo(profile, instance));
                }
            }
            ++searchLevel;
        }
        if (log.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("Found Services:\n");
            for (ServiceInfo service : resultingServices) {
                sb.append("---------------\n").append(service);
            }
            log.debug((Object)sb.toString());
        }
        Collections.sort(resultingServices);
        if (log.isDebugEnabled()) {
            sb = new StringBuilder();
            sb.append("Sorted Services:\n");
            for (ServiceInfo service : resultingServices) {
                sb.append("---------------\n").append(service);
            }
            log.debug((Object)sb.toString());
        }
        return resultingServices;
    }

    @Override
    public void addServiceLocatorEventListener(ServiceLocatorEventListener listener) {
        this.serviceProfileLocator.addServiceLocatorEventListener(listener);
    }

    @Override
    public void removeServiceLocatorEventListener(ServiceLocatorEventListener listener) {
        this.serviceProfileLocator.removeServiceLocatorEventListener(listener);
    }
}

