/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.implementation.model;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class FindIndex {
    private HashMap _indexesToTreemapsOfStatements = new HashMap();
    private StatementComparator _statementComparator = new StatementComparator();
    private int _totalSize = 0;

    public void addLookup(Statement statement) throws ModelException {
        Resource resource = statement.subject();
        Resource resource2 = statement.predicate();
        RDFNode rDFNode = statement.object();
        this.put(this.getLookupValue(null, null, rDFNode), statement);
        this.put(this.getLookupValue(null, resource2, null), statement);
        this.put(this.getLookupValue(null, resource2, rDFNode), statement);
        this.put(this.getLookupValue(resource, null, null), statement);
        this.put(this.getLookupValue(resource, null, rDFNode), statement);
        this.put(this.getLookupValue(resource, resource2, null), statement);
        this.put(this.getLookupValue(resource, resource2, rDFNode), statement);
    }

    private Integer getLookupValue(Resource resource, Resource resource2, RDFNode rDFNode) {
        int n = resource != null ? resource.hashCode() : 0;
        int n2 = resource2 != null ? resource2.hashCode() : 0;
        int n3 = rDFNode != null ? rDFNode.hashCode() : 0;
        int n4 = (n * 37 + n2) * 37 + n3;
        return new Integer(n4);
    }

    public Enumeration multiget(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        Integer n = this.getLookupValue(resource, resource2, rDFNode);
        return new FindIndexEnumeration(n);
    }

    private void put(Integer n, Statement statement) throws ModelException {
        TreeMap<StatementWrapper, StatementWrapper> treeMap = (TreeMap<StatementWrapper, StatementWrapper>)this._indexesToTreemapsOfStatements.get(n);
        if (treeMap == null) {
            treeMap = new TreeMap<StatementWrapper, StatementWrapper>(this._statementComparator);
            this._indexesToTreemapsOfStatements.put(n, treeMap);
        }
        StatementWrapper statementWrapper = new StatementWrapper(n, statement);
        treeMap.put(statementWrapper, statementWrapper);
        ++this._totalSize;
    }

    private void remove(Integer n, Statement statement) throws ModelException {
        TreeMap treeMap = (TreeMap)this._indexesToTreemapsOfStatements.get(n);
        if (treeMap == null) {
            return;
        }
        StatementWrapper statementWrapper = new StatementWrapper(n, statement);
        treeMap.remove(statementWrapper);
        --this._totalSize;
    }

    public void removeLookup(Statement statement) throws ModelException {
        Resource resource = statement.subject();
        Resource resource2 = statement.predicate();
        RDFNode rDFNode = statement.object();
        this.remove(this.getLookupValue(null, null, rDFNode), statement);
        this.remove(this.getLookupValue(null, resource2, null), statement);
        this.remove(this.getLookupValue(null, resource2, rDFNode), statement);
        this.remove(this.getLookupValue(resource, null, null), statement);
        this.remove(this.getLookupValue(resource, null, rDFNode), statement);
        this.remove(this.getLookupValue(resource, resource2, null), statement);
        this.remove(this.getLookupValue(resource, resource2, rDFNode), statement);
    }

    public int size() {
        return this._totalSize;
    }

    private class FindIndexEnumeration
    implements Enumeration {
        private Statement _currentStatement;
        private Iterator _treemapIterator;
        private Integer _enumerationIndex;

        public FindIndexEnumeration(Integer n) {
            this._enumerationIndex = n;
            TreeMap treeMap = (TreeMap)FindIndex.this._indexesToTreemapsOfStatements.get(this._enumerationIndex);
            if (treeMap == null) {
                return;
            }
            this._treemapIterator = treeMap.values().iterator();
            this.findNext();
        }

        private void findNext() {
            while (this._treemapIterator.hasNext()) {
                StatementWrapper statementWrapper = (StatementWrapper)this._treemapIterator.next();
                if (!this._enumerationIndex.equals(statementWrapper.index)) continue;
                this._currentStatement = statementWrapper.value;
                return;
            }
            this._currentStatement = null;
        }

        public boolean hasMoreElements() {
            return this._currentStatement != null;
        }

        public Object nextElement() {
            Statement statement = this._currentStatement;
            if (this._currentStatement != null) {
                this.findNext();
            }
            return statement;
        }
    }

    private class StatementComparator
    implements Comparator {
        StatementComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = object.hashCode();
            if (n2 < (n = object2.hashCode())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return object instanceof StatementComparator;
        }
    }

    private class StatementWrapper {
        public Integer index;
        public Statement value;

        public StatementWrapper(Integer n, Statement statement) {
            this.index = n;
            this.value = statement;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StatementWrapper)) {
                return false;
            }
            StatementWrapper statementWrapper = (StatementWrapper)object;
            if (!this.index.equals(statementWrapper.index)) {
                return false;
            }
            return this.value.equals(statementWrapper.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

