/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.syntax.RDFParser;
import org.w3c.rdf.syntax.RDFSerializer;
import org.w3c.rdf.syntax.SerializationException;
import org.w3c.rdf.util.ModelConsumer;
import org.w3c.rdf.util.SetOperations;
import org.w3c.rdf.vocabulary.rdf_syntax_19990222.RDF;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RDFUtil {
    public static void add(Model model, Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        model.add(model.getNodeFactory().createStatement(resource, resource2, rDFNode));
    }

    public static void collectNamespaces(Model model, Collection collection) throws ModelException {
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            RDFUtil.collectNamespaces(statement, collection);
        }
    }

    public static void collectNamespaces(Resource resource, Collection collection) throws ModelException {
        String string = resource.getNamespace();
        if (string != null) {
            collection.add(string);
        }
    }

    public static void collectNamespaces(Statement statement, Collection collection) throws ModelException {
        if (statement.subject() instanceof Statement) {
            RDFUtil.collectNamespaces((Statement)statement.subject(), collection);
        } else {
            RDFUtil.collectNamespaces(statement.subject(), collection);
        }
        RDFUtil.collectNamespaces(statement.predicate(), collection);
        if (statement.object() instanceof Statement) {
            RDFUtil.collectNamespaces((Statement)statement.object(), collection);
        } else if (statement.object() instanceof Resource) {
            RDFUtil.collectNamespaces((Resource)statement.object(), collection);
        }
    }

    public static void dumpModel(Model model, PrintStream printStream, RDFSerializer rDFSerializer) throws ModelException, IOException, SerializationException {
        rDFSerializer.serialize(model, new OutputStreamWriter(printStream));
    }

    public static String dumpModel(Model model, RDFSerializer rDFSerializer) throws ModelException, IOException, SerializationException {
        StringWriter stringWriter = new StringWriter();
        rDFSerializer.serialize(model, stringWriter);
        return stringWriter.toString();
    }

    public static Statement get1(Model model) throws ModelException {
        if (model == null || model.isEmpty()) {
            return null;
        }
        return (Statement)model.elements().nextElement();
    }

    public static String getLocalName(Resource resource) throws ModelException {
        if (resource.getNamespace() == null) {
            return RDFUtil.guessName(resource.getURI());
        }
        return resource.getLocalName();
    }

    public static String getNamespace(Resource resource) throws ModelException {
        String string = resource.getNamespace();
        return string != null ? string : RDFUtil.guessNamespace(resource.getURI());
    }

    static int getNamespaceEnd(String string) {
        char c;
        int n = string.length() - 1;
        while ((c = string.charAt(n)) != '#' && c != ':' && c != '/' && --n >= 0) {
        }
        return ++n;
    }

    public static Hashtable getNodes(Model model) throws ModelException {
        Hashtable<RDFNode, RDFNode> hashtable = new Hashtable<RDFNode, RDFNode>();
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            hashtable.put(statement.subject(), statement.subject());
            hashtable.put(statement.object(), statement.object());
        }
        return hashtable;
    }

    public static RDFNode getObject(Model model, Resource resource, Resource resource2) throws ModelException {
        Model model2 = model.find(resource, resource2, null);
        if (model2 == null || model2.size() == 0) {
            return null;
        }
        return ((Statement)model2.elements().nextElement()).object();
    }

    public static String getObjectLiteral(Model model, Resource resource, Resource resource2) throws ModelException {
        RDFNode rDFNode = RDFUtil.getObject(model, resource, resource2);
        if (rDFNode instanceof Literal) {
            return rDFNode.toString();
        }
        return null;
    }

    public static Resource getObjectResource(Model model, Resource resource, Resource resource2) throws ModelException {
        RDFNode rDFNode = RDFUtil.getObject(model, resource, resource2);
        if (rDFNode instanceof Resource) {
            return (Resource)rDFNode;
        }
        return null;
    }

    public static int getOrd(Resource resource) throws ModelException {
        block5: {
            if (resource == null) {
                return -1;
            }
            String string = resource.toString();
            if (!RDFUtil.isRDF(string)) {
                return -1;
            }
            int n = RDFUtil.getNamespaceEnd(string);
            if (n <= 0 || n + 1 >= string.length()) break block5;
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                if (n2 >= 1) {
                    return n2;
                }
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public static Model getReachable(Resource resource, Model model) throws ModelException {
        Model model2 = model.create();
        RDFUtil.getReachable(resource, model, model2);
        return model2;
    }

    static void getReachable(Resource resource, Model model, Model model2) throws ModelException {
        int n = model2.size();
        Model model3 = model.find(resource, null, null);
        SetOperations.unite(model2, model3);
        if (model2.size() == n) {
            return;
        }
        Enumeration enumeration = model3.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            if (!(statement.object() instanceof Resource)) continue;
            RDFUtil.getReachable((Resource)statement.object(), model, model2);
        }
    }

    public static Hashtable getResources(Model model) throws ModelException {
        Hashtable<RDFNode, RDFNode> hashtable = new Hashtable<RDFNode, RDFNode>();
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            hashtable.put(statement.subject(), statement.subject());
            if (!(statement.object() instanceof Resource)) continue;
            hashtable.put(statement.object(), statement.object());
        }
        return hashtable;
    }

    public static Statement[] getStatementArray(Model model) throws ModelException {
        Statement[] statementArray = new Statement[model.size()];
        int n = 0;
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            statementArray[n++] = statement;
        }
        return statementArray;
    }

    public static Vector getStatementVector(Model model) throws ModelException {
        Vector<Statement> vector = new Vector<Statement>();
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            vector.addElement(statement);
        }
        return vector;
    }

    public static Resource getSubject(Model model, Resource resource, RDFNode rDFNode) throws ModelException {
        Model model2 = model.find(null, resource, rDFNode);
        if (model2 == null || model2.size() == 0) {
            return null;
        }
        return ((Statement)model2.elements().nextElement()).subject();
    }

    public static String guessName(String string) {
        return string.substring(RDFUtil.getNamespaceEnd(string));
    }

    public static String guessNamespace(String string) {
        int n = RDFUtil.getNamespaceEnd(string);
        return n > 1 ? string.substring(0, n) : "";
    }

    public static boolean isInstanceOf(Model model, Resource resource, Resource resource2) throws ModelException {
        return model.find(resource, RDF.type, resource2).isEmpty() ^ true;
    }

    public static boolean isQualified(String string) {
        int n = string.length() - 1;
        do {
            char c;
            if ((c = string.charAt(n)) != '#' && c != ':') continue;
            return true;
        } while (--n >= 0);
        return false;
    }

    public static boolean isRDF(String string) {
        return string != null && string.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }

    public static boolean isRDF(Resource resource) throws ModelException {
        return RDFUtil.isRDF(resource.getURI());
    }

    public static Resource noname(Model model) throws ModelException {
        return model.getNodeFactory().createUniqueResource();
    }

    public static String normalizeURI(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            try {
                if (string.indexOf(58) == -1) {
                    uRL = new URL("file", null, string);
                }
            }
            catch (Exception exception2) {}
        }
        return uRL != null ? uRL.toString() : string;
    }

    public static void parse(String string, RDFParser rDFParser, Model model) throws IOException, SAXException, MalformedURLException, ModelException {
        URL uRL = new URL(RDFUtil.normalizeURI(string));
        model.setSourceURI(uRL.toString());
        InputSource inputSource = new InputSource(uRL.openStream());
        inputSource.setSystemId(uRL.toString());
        rDFParser.parse(inputSource, new ModelConsumer(model));
    }

    public static void printStatements(Model model, PrintStream printStream) throws ModelException {
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            printStream.println(statement);
        }
    }

    public static Model removeNamespace(String string, Model model) throws ModelException {
        Model model2 = model.duplicate();
        Enumeration enumeration = model.duplicate().elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            if (!statement.subject().toString().startsWith(string) && !statement.predicate().toString().startsWith(string) && !statement.object().toString().startsWith(string)) continue;
            model2.remove(statement);
        }
        return model2;
    }

    public static void saveModel(Model model, String string, RDFSerializer rDFSerializer) throws FileNotFoundException, IOException, ModelException, SerializationException {
        FileWriter fileWriter = new FileWriter(string);
        rDFSerializer.serialize(model, fileWriter);
        fileWriter.close();
    }

    public static void saveModel(Model model, RDFSerializer rDFSerializer) throws FileNotFoundException, IOException, ModelException, SerializationException {
        URL uRL = null;
        try {
            uRL = new URL(model.getSourceURI());
        }
        catch (Exception exception) {
            throw new ModelException("RDFUtil: cannot determine model file name: " + model.getSourceURI());
        }
        if (!"file".equals(uRL.getProtocol())) {
            throw new ModelException("RDFUtil: cannot save to non-file model URI: " + model.getSourceURI());
        }
        RDFUtil.saveModel(model, uRL.getFile().replace('/', File.separatorChar), rDFSerializer);
    }

    public static boolean setUniqueObject(Model model, Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        Model model2 = model.find(resource, resource2, null);
        SetOperations.subtract(model, model2);
        model.add(model.getNodeFactory().createStatement(resource, resource2, rDFNode));
        return model2.isEmpty() ^ true;
    }
}

