/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database.triplestore;

import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.database.triplestore.DatabaseTripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractTripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.TripleChangePostProcessor;

public class DatabaseTripleStoreModel
extends AbstractTripleStoreModel {
    private OWLDatabaseModel owlModel;
    private TripleStore systemTripleStore;
    private DatabaseTripleStore userTripleStore;

    public DatabaseTripleStoreModel(OWLDatabaseModel owlModel) {
        super(owlModel);
        this.owlModel = owlModel;
        NarrowFrameStore frameStore = this.mnfs.getActiveFrameStore();
        this.userTripleStore = new DatabaseTripleStore(owlModel, (TripleStoreModel)this, frameStore);
        NarrowFrameStore systemFrameStore = this.mnfs.getSystemFrameStore();
        this.systemTripleStore = new DatabaseTripleStore(owlModel, (TripleStoreModel)this, systemFrameStore);
        this.ts.add(this.systemTripleStore);
        this.ts.add(this.userTripleStore);
        if (this.userTripleStore.getName() == null) {
            this.userTripleStore.setName("top");
        }
    }

    public DatabaseTripleStoreModel(OWLDatabaseModel owlModel, NarrowFrameStore nfs) {
        super(owlModel);
        this.owlModel = owlModel;
        this.userTripleStore = new DatabaseTripleStore(owlModel, (TripleStoreModel)this, nfs);
        this.systemTripleStore = this.userTripleStore;
        this.ts.add(this.userTripleStore);
        if (this.userTripleStore.getName() == null) {
            this.userTripleStore.setName("top");
        }
    }

    public TripleStore createTripleStore(String name) {
        return this.userTripleStore;
    }

    public void deleteTripleStore(TripleStore tripleStore) {
    }

    public void endTripleStoreChanges() {
        this.owlModel.flushCache();
        TripleChangePostProcessor.postProcess(this.owlModel);
    }

    public TripleStore getTripleStoreByDefaultNamespace(String namespace) {
        return this.userTripleStore;
    }
}

