/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.emf;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.emf.EMFGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class EMFGenerator {
    private OWLModel owlModel;
    private EMFGeneratorOptions options;

    public EMFGenerator(OWLModel owlModel, EMFGeneratorOptions options) {
        String pack;
        this.owlModel = owlModel;
        this.options = options;
        File folder = options.getOutputFolder();
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        if ((pack = options.getPackage()) != null) {
            pack = pack.replace('.', '/');
            File file = folder == null ? new File(pack) : new File(folder, pack);
            file.mkdirs();
        }
    }

    public void createAllInterfaces() throws IOException {
        for (RDFSNamedClass aClass : this.owlModel.getUserDefinedOWLNamedClasses()) {
            this.createInterface(aClass);
        }
    }

    public void createInterface(RDFSNamedClass aClass) throws IOException {
        File file = this.getInterfaceFile(aClass);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.createInterfaceCode(printWriter, aClass);
        fileWriter.close();
    }

    public void createInterfaceCode(PrintWriter printWriter, RDFSNamedClass aClass) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ";");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by the EMFGenerator from the Protege OWL Plugin (http://protege.stanford.edu).");
        printWriter.println(" * Source OWL Class: " + aClass.getURI());
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" * @model");
        printWriter.println(" */");
        printWriter.println("public interface " + this.getInterfaceName(aClass) + this.getExtendsCode(aClass) + " {");
        for (Slot slot : aClass.getUnionDomainProperties()) {
            if (!(slot instanceof RDFProperty)) continue;
            this.createSlotCode(printWriter, aClass, (RDFProperty)slot);
        }
        printWriter.println("}");
    }

    private String getExtendsCode(RDFSNamedClass aClass) {
        String str = "";
        Iterator it = this.getBaseInterfaces(aClass).iterator();
        if (it.hasNext()) {
            str = String.valueOf(str) + " extends ";
            while (it.hasNext()) {
                String baseInterface = (String)it.next();
                str = String.valueOf(str) + baseInterface;
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
        }
        return str;
    }

    public void createSlotCode(PrintWriter printWriter, RDFSNamedClass aClass, RDFProperty property) {
        String name = EMFGenerator.getValidJavaName(property.getName());
        name = name.length() > 1 ? String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1) : name.toUpperCase();
        Class javaType = aClass.getTemplateSlotValueType(property).getJavaType();
        String javaTypeName = null;
        String modelAnnotations = null;
        if (aClass.getTemplateSlotAllowsMultipleValues(property)) {
            javaTypeName = "java.util.List";
            if (!aClass.getTemplateSlotAllowedClses(property).isEmpty()) {
                RDFSNamedClass range = (RDFSNamedClass)aClass.getTemplateSlotAllowedClses(property).iterator().next();
                modelAnnotations = " type=\"" + this.getInterfaceName(range) + "\"";
            }
        } else {
            javaTypeName = javaType.toString();
            int index = javaTypeName.lastIndexOf(46);
            if (index > 0) {
                javaTypeName = javaTypeName.substring(index + 1);
            }
        }
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Generated from property #" + property.getLocalName());
        printWriter.println("     * @model" + modelAnnotations);
        printWriter.println("     */");
        printWriter.println("    " + javaTypeName + " get" + name + "();");
    }

    public Collection getBaseInterfaces(RDFSNamedClass aClass) {
        ArrayList<String> results = new ArrayList<String>();
        for (Cls superCls : aClass.getSuperclasses(false)) {
            if (!(superCls instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(superCls)) continue;
            results.add(this.getInterfaceName((RDFSNamedClass)superCls));
        }
        return results;
    }

    public File getInterfaceFile(RDFSNamedClass aClass) {
        String pack = this.options.getPackage();
        pack = pack != null ? String.valueOf(pack.replace('.', '/')) + "/" : "";
        return new File(this.options.getOutputFolder(), String.valueOf(pack) + this.getInterfaceName(aClass) + ".java");
    }

    public String getInterfaceName(RDFSNamedClass aClass) {
        String name = aClass.getName();
        return EMFGenerator.getValidJavaName(name);
    }

    public static String getValidJavaName(String name) {
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                name = name.replace(c, '_');
            }
            ++i;
        }
        return name;
    }
}

