/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGRenderer;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DefaultDIGQueryResponseIterator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DefaultDIGRenderer;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultDIGTranslator
implements DIGTranslator {
    private DIGRenderer renderer = new DefaultDIGRenderer();
    private DocumentBuilderFactory docBuilderFactory;
    private DocumentBuilder docBuilder;
    public static final String DL_NAMESPACE = "http://dl.kr.org/dig/2003/02/lang";

    public DefaultDIGTranslator() {
        try {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void setReasonerIdentity(DIGReasonerIdentity reasonerIdentity) {
        this.renderer.setReasonerIdentity(reasonerIdentity);
    }

    public Document createTellsDocument(String kbURI) {
        Document doc = this.createDIGDocument("tells", kbURI);
        return doc;
    }

    public Document createAsksDocument(String kbURI) {
        Document doc = this.createDIGDocument("asks", kbURI);
        return doc;
    }

    public Document createDIGDocument(String rootTagName, String kbURI) {
        Document doc = this.createDIGDocument(rootTagName);
        doc.getDocumentElement().setAttribute("uri", kbURI);
        return doc;
    }

    public Document createDIGDocument(String rootTagName) {
        Document doc = this.docBuilder.newDocument();
        Element rootElement = doc.createElement(rootTagName);
        rootElement.setAttribute("xmlns", DL_NAMESPACE);
        doc.appendChild(rootElement);
        return doc;
    }

    public void translateToDIG(OWLModel kb, Document doc, Node node) throws DIGReasonerException {
        this.renderer.render(kb, doc, node);
    }

    public void translateToDIG(RDFResource i, Document doc, Node node) throws DIGReasonerException {
        if (i instanceof OWLNamedClass) {
            this.renderer.render((OWLNamedClass)i, doc, node);
        } else if (i instanceof OWLSomeValuesFrom) {
            this.renderer.render((OWLSomeValuesFrom)i, doc, node);
        } else if (i instanceof OWLAllValuesFrom) {
            this.renderer.render((OWLAllValuesFrom)i, doc, node);
        } else if (i instanceof OWLMinCardinality) {
            this.renderer.render((OWLMinCardinality)i, doc, node);
        } else if (i instanceof OWLMaxCardinality) {
            this.renderer.render((OWLMaxCardinality)i, doc, node);
        } else if (i instanceof OWLCardinality) {
            this.renderer.render((OWLCardinality)i, doc, node);
        } else if (i instanceof OWLIntersectionClass) {
            this.renderer.render((OWLIntersectionClass)i, doc, node);
        } else if (i instanceof OWLUnionClass) {
            this.renderer.render((OWLUnionClass)i, doc, node);
        } else if (i instanceof OWLComplementClass) {
            this.renderer.render((OWLComplementClass)i, doc, node);
        } else if (i instanceof OWLEnumeratedClass) {
            this.renderer.render((OWLEnumeratedClass)i, doc, node);
        } else if (i instanceof OWLObjectProperty) {
            this.renderer.render((OWLObjectProperty)i, doc, node);
        } else if (i instanceof OWLDatatypeProperty) {
            this.renderer.render((OWLDatatypeProperty)i, doc, node);
        } else if (i instanceof RDFIndividual) {
            this.renderer.render((RDFIndividual)i, doc, node);
        } else if (i instanceof OWLHasValue) {
            this.renderer.render((OWLHasValue)i, doc, node);
        } else {
            throw new IllegalArgumentException("Don't know how to translate " + i.getClass().getName());
        }
    }

    public Iterator getDIGQueryResponseIterator(OWLModel kb, Document doc) throws DIGReasonerException {
        return new DefaultDIGQueryResponseIterator(doc, kb);
    }

    public Element createQueryElement(Document doc, String name, String queryID) {
        Element element = doc.createElement(name);
        element.setAttribute("id", queryID);
        return element;
    }

    public void createAllConceptNamesQuery(Document doc, String queryID) {
        Element element = this.createQueryElement(doc, "allConceptNames", queryID);
        doc.getDocumentElement().appendChild(element);
    }

    public void createAllPropertyNamesQuery(Document doc, String queryID) {
        Element element = this.createQueryElement(doc, "allRoleNames", queryID);
        doc.getDocumentElement().appendChild(element);
    }

    public void createAllIndividualsQuery(Document doc, String queryID) {
        Element element = this.createQueryElement(doc, "allIndividuals", queryID);
        doc.getDocumentElement().appendChild(element);
    }

    public void createSatisfiableQuery(Document doc, String queryID, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "satisfiable", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createSatisfiableQuery(Document doc, String queryID, RDFSClass[] clses) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "satisfiable", queryID);
        Element intersectionElement = doc.createElement("and");
        element.appendChild(intersectionElement);
        int i = 0;
        while (i < clses.length) {
            this.translateToDIG(clses[i], doc, (Node)intersectionElement);
            ++i;
        }
        doc.getDocumentElement().appendChild(element);
    }

    public void createSubsumesQuery(Document doc, String queryID, RDFSClass cls1, RDFSClass cls2) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "subsumes", queryID);
        this.translateToDIG(cls1, doc, (Node)element);
        this.translateToDIG(cls2, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createDisjointQuery(Document doc, String queryID, RDFSClass cls1, RDFSClass cls2) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "disjoint", queryID);
        this.translateToDIG(cls1, doc, (Node)element);
        this.translateToDIG(cls2, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createDirectSuperConceptsQuery(Document doc, String queryID, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "parents", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createDirectSuperConceptsQuery(Document doc, String queryID, RDFSClass[] clses) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "parents", queryID);
        Element andElement = doc.createElement("and");
        element.appendChild(andElement);
        int i = 0;
        while (i < clses.length) {
            this.translateToDIG(clses[i], doc, (Node)andElement);
            ++i;
        }
        doc.getDocumentElement().appendChild(element);
    }

    public void createDirectSubConceptsQuery(Document doc, String queryID, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "children", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createAncestorConceptsQuery(Document doc, String queryID, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "ancestors", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createDescendantConceptsQuery(Document doc, String queryID, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "descendants", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createEquivalentConceptsQuery(Document doc, String queryID, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "equivalents", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createDirectSuperPropertiesQuery(Document doc, String queryID, OWLProperty property) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "rparents", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createDirectSubPropertiesQuery(Document doc, String queryID, OWLProperty property) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "rchildren", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createAncestorPropertiesQuery(Document doc, String queryID, OWLProperty property) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "rancestors", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createDescendantPropertiesQuery(Document doc, String queryID, OWLProperty property) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "rdescendants", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createInstancesOfConceptQuery(Document doc, String queryID, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "instances", queryID);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createIndividualTypesQuery(Document doc, String queryID, RDFIndividual ins) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "types", queryID);
        this.translateToDIG(ins, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createIndividualInstanceOfConceptQuery(Document doc, String queryID, RDFIndividual ins, RDFSClass aClass) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "instance", queryID);
        this.translateToDIG(ins, doc, (Node)element);
        this.translateToDIG(aClass, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createPropertyFillersQuery(Document doc, String queryID, RDFIndividual ins, OWLProperty property) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "rolefillers", queryID);
        this.translateToDIG(ins, doc, (Node)element);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }

    public void createRelatedIndividualsQuery(Document doc, String queryID, OWLProperty property) throws DIGReasonerException {
        Element element = this.createQueryElement(doc, "relatedIndividuals", queryID);
        this.translateToDIG(property, doc, (Node)element);
        doc.getDocumentElement().appendChild(element);
    }
}

