/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;

public class GetIndividualsBelongingToConceptTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLClass aClass;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private HashSet individuals;

    public GetIndividualsBelongingToConceptTask(OWLClass aClass, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.aClass = aClass;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.individuals = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecordFactory logRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord parentRecord = logRecordFactory.createInformationMessageLogRecord("Individuals belonging to: " + this.aClass.getBrowserText(), null);
        this.postLogRecord(parentRecord);
        this.setDescription("Computing individuals belonging to class");
        this.setMessage("Building reasoner query...");
        Document doc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createInstancesOfConceptQuery(doc, "q0", this.aClass);
        this.setMessage("Querying reasoner...");
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(doc);
        Iterator it = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        while (it.hasNext()) {
            DIGQueryResponse response = (DIGQueryResponse)it.next();
            this.individuals.addAll(response.getIndividuals());
        }
        this.setProgress(1);
        Iterator individualsIt = this.individuals.iterator();
        while (individualsIt.hasNext()) {
            this.postLogRecord(ReasonerLogRecordFactory.getInstance().createOWLInstanceLogRecord((RDFResource)individualsIt.next(), parentRecord));
        }
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.individuals;
    }
}

