/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.RDFPropertyAtClassCode;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class RDFSClassCode {
    private RDFSNamedClass cls;

    public RDFSClassCode(RDFSNamedClass cls) {
        this.cls = cls;
    }

    public String getJavaName() {
        return RDFSClassCode.getValidJavaName(this.cls.getLocalName());
    }

    public List getPropertyCodes() {
        HashSet<RDFProperty> properties = new HashSet<RDFProperty>();
        ArrayList<RDFPropertyAtClassCode> codes = new ArrayList<RDFPropertyAtClassCode>();
        Collection unionDomainProperties = this.cls.getUnionDomainProperties();
        HashSet<RDFProperty> relevantProperties = new HashSet<RDFProperty>(unionDomainProperties);
        if (this.cls instanceof OWLNamedClass) {
            OWLNamedClass owlNamedClass = (OWLNamedClass)this.cls;
            for (OWLRestriction restriction : owlNamedClass.getRestrictions()) {
                relevantProperties.add(restriction.getOnProperty());
            }
        }
        for (RDFProperty property : relevantProperties) {
            properties.add(property);
            RDFPropertyAtClassCode code = new RDFPropertyAtClassCode(this.cls, property);
            codes.add(code);
            Collection subproperties = property.getSubproperties(true);
            for (RDFProperty subproperty : subproperties) {
                if (subproperty.isDomainDefined() || properties.contains(subproperty)) continue;
                codes.add(new RDFPropertyAtClassCode(this.cls, subproperty));
                properties.add(subproperty);
            }
        }
        Collections.sort(codes);
        return codes;
    }

    public static String getValidJavaName(String name) {
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                name = name.replace(c, '_');
            }
            ++i;
        }
        return name;
    }
}

