/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.OWLFilesPlugin;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.model.util.XSDVisibility;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchClassDefinitionResourceDisplayPlugin;
import edu.stanford.smi.protegex.owl.ui.jena.OWLFilesWizardPage;
import edu.stanford.smi.protegex.owl.ui.menu.OWLMenuProjectPlugin;
import edu.stanford.smi.protegex.owl.ui.metadatatab.OntologyURIWizardPage;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfileSelectionWizardPage;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OWLFilesCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements OWLFilesPlugin {
    private static transient Logger log = Log.getLogger(OWLFilesCreateProjectPlugin.class);
    private Class defaultClassView;
    private String defaultNamespace;
    private Collection imports = new ArrayList();
    private Map importPrefixes = new HashMap();
    private String fileURI;
    private String lang;
    private String profileURI;

    public OWLFilesCreateProjectPlugin() {
        super("OWL Files");
        JenaKnowledgeBaseFactory.useStandalone = false;
    }

    public void addImport(String uri, String prefix) {
        this.imports.add(uri);
        this.importPrefixes.put(uri, prefix);
    }

    protected void addImports(Project project) {
        JenaOWLModel owlModel = (JenaOWLModel)project.getKnowledgeBase();
        if (this.imports.contains("http://www.w3.org/2003/11/swrl")) {
            Collection tabWidgetDescriptors = project.getTabWidgetDescriptors();
            WidgetDescriptor w = project.getTabWidgetDescriptor(SWRLTab.class.getName());
            w.setVisible(true);
            project.setTabWidgetDescriptorOrder(tabWidgetDescriptors);
            owlModel.getNamespaceManager().setPrefix("http://www.w3.org/2003/11/swrl#", "swrl");
            owlModel.getNamespaceManager().setPrefix("http://www.w3.org/2003/11/swrlb#", "swrlb");
        }
        ImportHelper importHelper = new ImportHelper(owlModel);
        for (String uri : this.imports) {
            String prefix = (String)this.importPrefixes.get(uri);
            String namespace = uri;
            if (!namespace.endsWith("#") && !namespace.endsWith("/")) {
                namespace = String.valueOf(namespace) + "#";
            }
            owlModel.getNamespaceManager().setPrefix(namespace, prefix);
            if (namespace.equals(ProtegeNames.NS)) {
                owlModel.getNamespaceManager().setPrefix("http://www.owl-ontologies.com/2005/08/07/xsp.owl#", "xsp");
            }
            try {
                URI u = new URI(uri);
                importHelper.addImport(u);
            }
            catch (URISyntaxException e) {
                log.log(Level.SEVERE, "Exception caught", e);
            }
        }
        try {
            importHelper.importOntologies();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception caught", ex);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not load import:\n" + ex);
        }
        if (this.imports.contains("http://www.w3.org/2003/11/swrl")) {
            SWRLProjectPlugin.adjustWidgets(project);
        }
        if (!this.imports.isEmpty()) {
            owlModel.getTripleStoreModel().updateEditableResourceState();
        }
    }

    private void addViewSettings(PropertyList sources) {
        String typeName = null;
        typeName = this.defaultClassView == null ? SwitchClassDefinitionResourceDisplayPlugin.getDefaultClassView() : this.defaultClassView.getName();
        SwitchClassDefinitionResourceDisplayPlugin.setClassesView(sources, typeName);
        SwitchClassDefinitionResourceDisplayPlugin.setDefaultClassesView(typeName);
        if (this.profileURI != null) {
            ProfilesManager.setProfile(sources, this.profileURI);
        }
    }

    protected Project buildNewProject(KnowledgeBaseFactory factory) {
        ProtegeOWLParser.inUI = true;
        Project project = this.buildNewProject2(factory);
        if (project != null) {
            OWLModel owlModel = (OWLModel)project.getKnowledgeBase();
            OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(owlModel);
            if (SWRLProjectPlugin.isSWRLImported(owlModel)) {
                SWRLProjectPlugin.adjustWidgets(project);
            }
            XSDVisibility.updateVisibility(owlModel);
        }
        ProtegeOWLParser.inUI = true;
        return project;
    }

    private Project buildNewProject2(KnowledgeBaseFactory factory) {
        ArrayList errors = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)factory, errors);
        this.initialize(project);
        URI uri = this.getBuildProjectURI();
        if (uri != null) {
            project.setProjectURI(uri);
        }
        project.createDomainKnowledgeBase(factory, errors, true);
        this.handleErrors(errors);
        return project;
    }

    public boolean canCreateProject(KnowledgeBaseFactory factory, boolean useExistingSources) {
        return factory.getClass() == JenaKnowledgeBaseFactory.class;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard wizard, boolean useExistingSources) {
        ProfileSelectionWizardPage.isBuild = useExistingSources;
        if (useExistingSources) {
            return new OWLFilesWizardPage((Wizard)wizard, this);
        }
        return new OntologyURIWizardPage((Wizard)wizard, this);
    }

    protected Project createNewProject(KnowledgeBaseFactory factory) {
        ArrayList errors = new ArrayList();
        Project project = Project.createNewProject((KnowledgeBaseFactory)factory, errors);
        OWLModel owlModel = (OWLModel)project.getKnowledgeBase();
        if (this.defaultNamespace != null) {
            owlModel.getNamespaceManager().setDefaultNamespace(this.defaultNamespace);
        }
        this.addViewSettings(project.getSources());
        this.addImports(project);
        OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(owlModel);
        return project;
    }

    protected URI getBuildProjectURI() {
        int index;
        if (this.fileURI != null && this.fileURI.startsWith("file:") && (index = this.fileURI.lastIndexOf(46)) > 0) {
            String uri = FileUtilities.replaceExtension((String)this.fileURI, (String)".pprj");
            try {
                return new URI(uri);
            }
            catch (Exception ex) {
                Log.emptyCatchBlock((Throwable)ex);
            }
        }
        return super.getBuildProjectURI();
    }

    protected void initializeSources(PropertyList sources) {
        JenaKnowledgeBaseFactory.setOWLFileName(sources, this.fileURI);
        JenaKnowledgeBaseFactory.setOWLFileLanguage(sources, this.lang);
        this.addViewSettings(sources);
    }

    public void setDublinCoreRedirectToDLVersion(boolean b) {
    }

    public void setFile(String fileURI) {
        this.fileURI = fileURI;
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    public void setDefaultClassView(Class typeClass) {
        this.defaultClassView = typeClass;
        SwitchClassDefinitionResourceDisplayPlugin.setDefaultClassesView(typeClass.getName());
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public void setProfile(String profileURI) {
        this.profileURI = profileURI;
    }
}

