/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;

public class CreateSomeValuesFromRestrictionsTestCase
extends AbstractJenaCreatorTestCase {
    public void testCreateSomeRestrictionWithClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, cls));
        OntModel ontModel = this.runJenaCreator();
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateSomeValuesFromRestrictionsTestCase.assertTrue((boolean)r.canAs(SomeValuesFromRestriction.class));
        SomeValuesFromRestriction ar = r.asSomeValuesFromRestriction();
        CreateSomeValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(slot.getURI()), (Object)ar.getOnProperty());
        CreateSomeValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.getOntClass(cls.getURI()), (Object)ar.getSomeValuesFrom());
    }

    public void testCreateSomeRestrictionWithDataRange() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        OWLSomeValuesFrom restriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, new RDFSLiteral[]{this.owlModel.createRDFSLiteral("A"), this.owlModel.createRDFSLiteral("B")});
        cls.addSuperclass(restriction);
        OntModel ontModel = this.runJenaCreator();
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateSomeValuesFromRestrictionsTestCase.assertTrue((boolean)r.canAs(SomeValuesFromRestriction.class));
        SomeValuesFromRestriction ar = r.asSomeValuesFromRestriction();
        CreateSomeValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(slot.getURI()), (Object)ar.getOnProperty());
        Resource resource = ar.getSomeValuesFrom();
        CreateSomeValuesFromRestrictionsTestCase.assertTrue((boolean)resource.canAs(DataRange.class));
        DataRange dataRange = (DataRange)resource.as(DataRange.class);
        ExtendedIterator it = dataRange.listOneOf();
        CreateSomeValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.createTypedLiteral((Object)"A"), it.next());
        CreateSomeValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.createTypedLiteral((Object)"B"), it.next());
        CreateSomeValuesFromRestrictionsTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testCreateSomeRestrictionWithDatatype() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, this.owlModel.getXSDstring()));
        OntModel newModel = this.runJenaCreator();
        Restriction r = this.getRestriction(newModel.getOntClass(cls.getURI()));
        CreateSomeValuesFromRestrictionsTestCase.assertTrue((boolean)r.canAs(SomeValuesFromRestriction.class));
        SomeValuesFromRestriction ar = r.asSomeValuesFromRestriction();
        CreateSomeValuesFromRestrictionsTestCase.assertEquals((Object)newModel.getOntProperty(slot.getURI()), (Object)ar.getOnProperty());
        Resource resource = ar.getSomeValuesFrom();
        CreateSomeValuesFromRestrictionsTestCase.assertEquals((String)XMLSchemaDatatypes.getValueTypeURI(ValueType.STRING), (String)resource.getURI());
    }
}

