/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadOWLFunctionalPropertyTestCase
extends AbstractJenaTestCase {
    public void testLoadFunctionalProperty() throws Exception {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setFunctional(true);
        JenaOWLModel newModel = LoadOWLFunctionalPropertyTestCase.reload(this.owlModel);
        OntModel newOntModel = newModel.getOntModel();
        Jena.dumpRDF(newOntModel);
        RDFProperty newProperty = newModel.getRDFProperty(property.getName());
        LoadOWLFunctionalPropertyTestCase.assertTrue((boolean)newProperty.isFunctional());
    }

    public void testLoadFunctionalAnnotationProperty() throws Exception {
        this.loadRemoteOntology("functional.owl");
        OWLProperty property = this.owlModel.getOWLProperty("functionalAnnotationProperty");
        LoadOWLFunctionalPropertyTestCase.assertTrue((boolean)property.isAnnotationProperty());
        LoadOWLFunctionalPropertyTestCase.assertTrue((boolean)property.isFunctional());
    }

    public void testLoadFunctionalDatatypeProperty() throws Exception {
        this.loadRemoteOntology("functional.owl");
        OWLProperty property = this.owlModel.getOWLProperty("functionalProperty");
        LoadOWLFunctionalPropertyTestCase.assertFalse((boolean)property.isAnnotationProperty());
        LoadOWLFunctionalPropertyTestCase.assertTrue((boolean)property.isFunctional());
    }
}

