/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import java.util.Iterator;

public class CreateXMLSchemaDatatypeLiteralsTestCase
extends AbstractProtege2JenaTestCase {
    public void testAnyURI() {
        XSDDatatype anyURI = XSDDatatype.XSDanyURI;
        RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(anyURI.getURI());
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", datatype);
        slot.setDomainDefined(false);
        String uri = "http://aldi.de";
        slot.setPropertyValue(slot, this.owlModel.createRDFSLiteral("http://aldi.de", datatype));
        OntModel newModel = this.createOntModel();
        DatatypeProperty datatypeProperty = newModel.getDatatypeProperty(slot.getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)anyURI.getURI(), (String)datatypeProperty.getRange().getURI());
        RDFNode node = datatypeProperty.getPropertyValue((Property)datatypeProperty);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertTrue((boolean)node.canAs(Literal.class));
        Literal literal = (Literal)node.as(Literal.class);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((Object)anyURI, (Object)literal.getDatatype());
    }

    public void testXMLLiteral() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getRDFXMLLiteralType());
        slot.setDomainDefined(false);
        String value = "<P>test</P>";
        slot.addPropertyValue(slot, this.owlModel.createRDFSLiteral(value, this.owlModel.getRDFXMLLiteralType()));
        OntModel newModel = this.createOntModel();
        DatatypeProperty property = newModel.getDatatypeProperty(slot.getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)XMLLiteralType.theXMLLiteralType.getURI(), (String)property.getRange().getURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertSize(1, (Iterator)property.listProperties((Property)property));
        RDFNode node = property.getPropertyValue((Property)property);
        Literal literal = (Literal)node.as(Literal.class);
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)XMLLiteralType.theXMLLiteralType.getURI(), (String)literal.getDatatypeURI());
        CreateXMLSchemaDatatypeLiteralsTestCase.assertEquals((String)value, (String)literal.getString());
    }
}

