/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class GetPropertyValuesTestCase
extends AbstractJenaTestCase {
    public void testAddValues() {
        OWLNamedClass resource = this.owlModel.getOWLThingClass();
        RDFProperty property = this.owlModel.getOWLVersionInfoProperty();
        String value = "1.1";
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ts.add(resource, property, value);
        Collection values = this.owlModel.getTripleStoreModel().getPropertyValues(resource, property);
        GetPropertyValuesTestCase.assertSize(1, values);
        GetPropertyValuesTestCase.assertContains((Object)value, values);
    }

    public void testAddRDFSLiteral() {
        OWLNamedClass resource = this.owlModel.getOWLThingClass();
        RDFProperty property = this.owlModel.getOWLVersionInfoProperty();
        String value = "1.1";
        String lang = "de";
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        RDFSLiteral oldLiteral = this.owlModel.createRDFSLiteral(value, lang);
        ts.add(resource, property, oldLiteral);
        Collection values = this.owlModel.getTripleStoreModel().getPropertyValues(resource, property);
        GetPropertyValuesTestCase.assertSize(1, values);
        RDFSLiteral newLiteral = (RDFSLiteral)values.iterator().next();
        GetPropertyValuesTestCase.assertEquals((String)value, (String)newLiteral.getString());
        GetPropertyValuesTestCase.assertEquals((String)lang, (String)newLiteral.getLanguage());
    }
}

