/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.event.tests;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class PropertyListenerTestCase
extends AbstractJenaTestCase {
    private int eventCount = 0;
    private PropertyListener listener = new PropertyAdapter(){

        public void subpropertyAdded(RDFProperty property, RDFProperty subproperty) {
            PropertyListenerTestCase propertyListenerTestCase = PropertyListenerTestCase.this;
            propertyListenerTestCase.eventCount = propertyListenerTestCase.eventCount + 1;
        }

        public void subpropertyRemoved(RDFProperty property, RDFProperty subproperty) {
            PropertyListenerTestCase propertyListenerTestCase = PropertyListenerTestCase.this;
            propertyListenerTestCase.eventCount = propertyListenerTestCase.eventCount + 1;
        }

        public void superpropertyAdded(RDFProperty property, RDFProperty superproperty) {
            PropertyListenerTestCase propertyListenerTestCase = PropertyListenerTestCase.this;
            propertyListenerTestCase.eventCount = propertyListenerTestCase.eventCount + 1;
        }

        public void superpropertyRemoved(RDFProperty property, RDFProperty superproperty) {
            PropertyListenerTestCase propertyListenerTestCase = PropertyListenerTestCase.this;
            propertyListenerTestCase.eventCount = propertyListenerTestCase.eventCount + 1;
        }

        public void unionDomainClassAdded(RDFProperty property, RDFSClass rdfsClass) {
            PropertyListenerTestCase propertyListenerTestCase = PropertyListenerTestCase.this;
            propertyListenerTestCase.eventCount = propertyListenerTestCase.eventCount + 1;
        }

        public void unionDomainClassRemoved(RDFProperty property, RDFSClass rdfsClass) {
            PropertyListenerTestCase propertyListenerTestCase = PropertyListenerTestCase.this;
            propertyListenerTestCase.eventCount = propertyListenerTestCase.eventCount + 1;
        }
    };

    public void testEvents() {
        RDFSNamedClass domainClass = this.owlModel.createRDFSNamedClass("Class");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFProperty subProperty = this.owlModel.createRDFProperty("sub");
        property.addPropertyListener(this.listener);
        subProperty.addPropertyListener(this.listener);
        subProperty.addSuperproperty(property);
        PropertyListenerTestCase.assertEquals((int)3, (int)this.eventCount);
        subProperty.removeSuperproperty(property);
        PropertyListenerTestCase.assertEquals((int)6, (int)this.eventCount);
        property.addUnionDomainClass(domainClass);
        PropertyListenerTestCase.assertEquals((int)7, (int)this.eventCount);
        property.removeUnionDomainClass(domainClass);
        PropertyListenerTestCase.assertEquals((int)8, (int)this.eventCount);
    }
}

