/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory.tests;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.tests.TestPerson;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class PolymorphismTestCase
extends AbstractJenaTestCase {
    public void testSystemResources() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        PolymorphismTestCase.assertTrue((boolean)cls.canAs(OWLNamedClass.class));
        PolymorphismTestCase.assertTrue((boolean)cls.canAs(RDFSNamedClass.class));
        PolymorphismTestCase.assertTrue((boolean)cls.canAs(RDFResource.class));
        PolymorphismTestCase.assertFalse((boolean)cls.canAs(OWLAnonymousClass.class));
        PolymorphismTestCase.assertFalse((boolean)cls.canAs(OWLObjectProperty.class));
        PolymorphismTestCase.assertTrue((boolean)(cls.as(RDFSNamedClass.class) instanceof OWLNamedClass));
    }

    public void testPerson() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("TestPerson");
        RDFIndividual individual = cls.createRDFIndividual("MyPerson");
        PolymorphismTestCase.assertTrue((boolean)individual.canAs(TestPerson.class));
        RDFResource cast = individual.as(TestPerson.class);
        PolymorphismTestCase.assertTrue((boolean)(cast instanceof TestPerson));
        PolymorphismTestCase.assertEquals((Object)individual, (Object)cast);
    }
}

