/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class EquivalentClassTestCase
extends AbstractJenaTestCase {
    public void testOnlyAnonymousEquivalentClass() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass herbivoreCls = this.owlModel.createOWLNamedClass("Herbivore");
        OWLNamedClass plantCls = this.owlModel.createOWLNamedClass("Plant");
        herbivoreCls.addSuperclass(animalCls);
        herbivoreCls.removeSuperclass(this.owlThing);
        OWLObjectProperty eatsProperty = this.owlModel.createOWLObjectProperty("eats");
        herbivoreCls.removeSuperclass(animalCls);
        herbivoreCls.addEquivalentClass(animalCls);
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)eatsProperty, plantCls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(restriction);
        herbivoreCls.setDefinition(intersectionCls);
        EquivalentClassTestCase.assertEquals((int)2, (int)herbivoreCls.getSuperclassCount());
        EquivalentClassTestCase.assertTrue((boolean)herbivoreCls.getSuperclasses(false).contains(animalCls));
    }

    public void testOWLEquivalentClassTriple1() {
        RDFProperty property = this.owlModel.getOWLEquivalentClassProperty();
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        OWLComplementClass other = this.owlModel.createOWLComplementClass(c);
        c.addSuperclass(other);
        EquivalentClassTestCase.assertSize(0, c.getPropertyValues(property));
        other.addSuperclass(c);
        EquivalentClassTestCase.assertSize(1, c.getPropertyValues(property));
        EquivalentClassTestCase.assertEquals((Object)other, (Object)c.getPropertyValue(property));
    }

    public void testOWLEquivalentClassTriple2() {
        RDFProperty property = this.owlModel.getOWLEquivalentClassProperty();
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        OWLComplementClass other = this.owlModel.createOWLComplementClass(c);
        other.addSuperclass(c);
        EquivalentClassTestCase.assertSize(0, c.getPropertyValues(property));
        c.addSuperclass(other);
        EquivalentClassTestCase.assertSize(1, c.getPropertyValues(property));
        EquivalentClassTestCase.assertEquals((Object)other, (Object)c.getPropertyValue(property));
    }
}

