/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;
import java.util.Collections;

public class AbstractRDFSClassTestCase
extends AbstractJenaTestCase {
    public void testSuperclasses() {
        RDFSNamedClass superclass = this.owlModel.createRDFSNamedClass("superclass");
        RDFSNamedClass middleclass = this.owlModel.createRDFSNamedSubclass("middleclass", superclass);
        RDFSNamedClass subclass = this.owlModel.createRDFSNamedSubclass("subclass", middleclass);
        AbstractRDFSClassTestCase.assertEquals((int)1, (int)superclass.getSubclassCount());
        AbstractRDFSClassTestCase.assertEquals((int)1, (int)middleclass.getSubclassCount());
        AbstractRDFSClassTestCase.assertEquals((int)0, (int)subclass.getSubclassCount());
        AbstractRDFSClassTestCase.assertSize(1, superclass.getSubclasses(false));
        AbstractRDFSClassTestCase.assertSize(2, superclass.getSubclasses(true));
        AbstractRDFSClassTestCase.assertTrue((boolean)subclass.isSubclassOf(middleclass));
        AbstractRDFSClassTestCase.assertTrue((boolean)middleclass.isSubclassOf(superclass));
        AbstractRDFSClassTestCase.assertEquals((int)1, (int)superclass.getSuperclassCount());
        AbstractRDFSClassTestCase.assertEquals((int)1, (int)middleclass.getSuperclassCount());
        AbstractRDFSClassTestCase.assertEquals((int)1, (int)subclass.getSuperclassCount());
        AbstractRDFSClassTestCase.assertSize(1, superclass.getSuperclasses(false));
        AbstractRDFSClassTestCase.assertSize(1, middleclass.getSuperclasses(false));
        AbstractRDFSClassTestCase.assertSize(2, middleclass.getSuperclasses(true));
        AbstractRDFSClassTestCase.assertSize(3, subclass.getSuperclasses(true));
        AbstractRDFSClassTestCase.assertContains((Object)this.owlThing, subclass.getSuperclasses(true));
        AbstractRDFSClassTestCase.assertContains((Object)superclass, subclass.getSuperclasses(true));
        AbstractRDFSClassTestCase.assertContains((Object)middleclass, subclass.getSuperclasses(true));
    }

    public void testSuperclassesOfRDFProperty() {
        RDFSNamedClass rdfPropertyClass = this.owlModel.getRDFPropertyClass();
        Collection ss = rdfPropertyClass.getSuperclasses(false);
        AbstractRDFSClassTestCase.assertSize(1, ss);
        AbstractRDFSClassTestCase.assertContains((Object)this.owlModel.getOWLThingClass(), ss);
    }

    public void testInferredInstances() {
        OWLNamedClass superClass = this.owlModel.createOWLNamedClass("Super");
        OWLNamedClass middleClass = this.owlModel.createOWLNamedSubclass("Middle", superClass);
        OWLNamedClass subClass = this.owlModel.createOWLNamedSubclass("Sub", middleClass);
        RDFIndividual indi = (RDFIndividual)superClass.createInstance("individual");
        indi.setInferredTypes(Collections.singleton(middleClass));
        AbstractRDFSClassTestCase.assertSize(1, indi.getInferredTypes());
        AbstractRDFSClassTestCase.assertContains((Object)middleClass, indi.getInferredTypes());
        AbstractRDFSClassTestCase.assertSize(0, superClass.getInferredInstances(false));
        AbstractRDFSClassTestCase.assertSize(1, superClass.getInferredInstances(true));
        AbstractRDFSClassTestCase.assertSize(1, middleClass.getInferredInstances(false));
        AbstractRDFSClassTestCase.assertSize(1, middleClass.getInferredInstances(true));
        AbstractRDFSClassTestCase.assertSize(0, subClass.getInferredInstances(false));
        AbstractRDFSClassTestCase.assertSize(0, subClass.getInferredInstances(true));
    }

    public void testUnionDomainOnlyReturnsRDFProperties() {
        Collection properties = this.owlModel.getOWLThingClass().getUnionDomainProperties();
        for (Object o : properties) {
            AbstractRDFSClassTestCase.assertTrue((boolean)(o instanceof RDFProperty));
        }
    }

    public void testUnionRangeClassNoRestriction() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setDomain(cls);
        AbstractRDFSClassTestCase.assertSize(0, cls.getUnionRangeClasses(property));
        property.setRange(cls);
        AbstractRDFSClassTestCase.assertSize(1, cls.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertContains((Object)cls, cls.getUnionRangeClasses(property));
    }

    public void testUnionRangeClassDirectRestriction() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setDomain(cls);
        AbstractRDFSClassTestCase.assertSize(0, cls.getUnionRangeClasses(property));
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom(property, cls));
        AbstractRDFSClassTestCase.assertSize(1, cls.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertContains((Object)cls, cls.getUnionRangeClasses(property));
    }

    public void testUnionRangeClassOverloadedRestriction() {
        RDFSNamedClass superclass = this.owlModel.createRDFSNamedClass("Superclass");
        RDFSNamedClass subclass = this.owlModel.createRDFSNamedSubclass("Subclass", superclass);
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setDomain(superclass);
        AbstractRDFSClassTestCase.assertSize(0, superclass.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertSize(0, subclass.getUnionRangeClasses(property));
        superclass.addSuperclass(this.owlModel.createOWLAllValuesFrom(property, superclass));
        AbstractRDFSClassTestCase.assertSize(1, superclass.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertContains((Object)superclass, superclass.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertSize(1, subclass.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertContains((Object)superclass, subclass.getUnionRangeClasses(property));
        subclass.addSuperclass(this.owlModel.createOWLAllValuesFrom(property, subclass));
        AbstractRDFSClassTestCase.assertSize(1, superclass.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertContains((Object)superclass, superclass.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertSize(1, subclass.getUnionRangeClasses(property));
        AbstractRDFSClassTestCase.assertContains((Object)subclass, subclass.getUnionRangeClasses(property));
    }
}

