/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DatatypeEnumerationTestCase
extends AbstractJenaTestCase {
    public void testAllValuesFromWithStringDataRange() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, new RDFSLiteral[]{this.owlModel.createRDFSLiteral("A"), this.owlModel.createRDFSLiteral("B")});
        DatatypeEnumerationTestCase.assertEquals((String)"owl:oneOf{\"A\" \"B\"}", (String)restriction.getFillerText());
    }

    public void testAllValuesFromWithFloatDataRange() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDfloat());
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, new RDFSLiteral[]{this.owlModel.createRDFSLiteral(new Float(1.1)), this.owlModel.createRDFSLiteral(new Float(2.2))});
        DatatypeEnumerationTestCase.assertEquals((String)"owl:oneOf{1.1 2.2}", (String)restriction.getFillerText());
    }

    public void testAllValuesFromWithIntegerDataRange() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDint());
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, new RDFSLiteral[]{this.owlModel.createRDFSLiteral(new Integer(1)), this.owlModel.createRDFSLiteral(new Integer(2))});
        DatatypeEnumerationTestCase.assertEquals((String)"owl:oneOf{1 2}", (String)restriction.getFillerText());
    }
}

