/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Arrays;
import java.util.Collection;

public class GetDependingClassesTestCase
extends AbstractJenaTestCase {
    public void testAllRestriction() {
        OWLNamedClass namedCls = this.owlModel.createOWLNamedClass("A");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(namedCls);
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, complementCls);
        Collection deps = restriction.getDependingClasses();
        GetDependingClassesTestCase.assertSize(1, deps);
        GetDependingClassesTestCase.assertContains((Object)complementCls, deps);
    }

    public void testAllRestrictionWithNamedCls() {
        OWLNamedClass namedCls = this.owlModel.createOWLNamedClass("A");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, namedCls);
        GetDependingClassesTestCase.assertSize(0, restriction.getDependingClasses());
    }

    public void testComplementCls() {
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(aCls);
        GetDependingClassesTestCase.assertSize(0, complementCls.getDependingClasses());
    }

    public void testIntersectionCls() {
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass cCls = this.owlModel.createOWLNamedClass("C");
        OWLComplementClass complementA = this.owlModel.createOWLComplementClass(aCls);
        OWLComplementClass complementC = this.owlModel.createOWLComplementClass(cCls);
        OWLIntersectionClass logicalCls = this.owlModel.createOWLIntersectionClass(Arrays.asList(complementA, bCls, complementC));
        Collection deps = logicalCls.getDependingClasses();
        GetDependingClassesTestCase.assertSize(2, deps);
        GetDependingClassesTestCase.assertContains((Object)complementA, deps);
        GetDependingClassesTestCase.assertContains((Object)complementC, deps);
    }

    public void testSomeRestriction() {
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(aCls);
        unionCls.addOperand(bCls);
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(unionCls);
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLSomeValuesFrom restriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, complementCls);
        Collection deps = restriction.getDependingClasses();
        GetDependingClassesTestCase.assertSize(1, deps);
        GetDependingClassesTestCase.assertContains((Object)complementCls, deps);
    }

    public void testUnionCls() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass cCls = this.owlModel.createOWLNamedClass("C");
        OWLComplementClass complementA = this.owlModel.createOWLComplementClass(aCls);
        OWLComplementClass complementC = this.owlModel.createOWLComplementClass(cCls);
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, complementC);
        OWLUnionClass logicalCls = this.owlModel.createOWLUnionClass(Arrays.asList(complementA, bCls, restriction));
        Collection deps = logicalCls.getDependingClasses();
        GetDependingClassesTestCase.assertSize(2, deps);
        GetDependingClassesTestCase.assertContains((Object)complementA, deps);
        GetDependingClassesTestCase.assertContains((Object)restriction, deps);
    }
}

