/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.query.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Map;

public class SPARQLQueryResultsTestCase
extends AbstractJenaTestCase {
    public void testSimpleQuery() throws Exception {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        String query = "SELECT ?subject WHERE { ?subject rdf:type owl:Class }";
        QueryResults results = this.owlModel.executeSPARQLQuery(query);
        SPARQLQueryResultsTestCase.assertTrue((boolean)results.hasNext());
        SPARQLQueryResultsTestCase.assertSize(1, results.getVariables());
        Object var = results.getVariables().get(0);
        SPARQLQueryResultsTestCase.assertEquals((Object)"subject", var);
        Map map = results.next();
        SPARQLQueryResultsTestCase.assertFalse((boolean)results.hasNext());
        SPARQLQueryResultsTestCase.assertEquals((int)1, (int)map.size());
        SPARQLQueryResultsTestCase.assertEquals((Object)c, map.get(var));
    }

    public void testXSDIntegerQueryFindObject() throws Exception {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("hasAge");
        RDFResource individual = cls.createInstance("Klaus");
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("18", this.owlModel.getXSDinteger());
        individual.setPropertyValue(property, literal);
        SPARQLQueryResultsTestCase.assertEquals((Object)literal, (Object)individual.getPropertyValue(property));
        String query = "SELECT ?object WHERE { ?subject :hasAge ?object }";
        QueryResults results = this.owlModel.executeSPARQLQuery(query);
        SPARQLQueryResultsTestCase.assertTrue((boolean)results.hasNext());
        Object var = results.getVariables().get(0);
        Map map = results.next();
        SPARQLQueryResultsTestCase.assertFalse((boolean)results.hasNext());
        SPARQLQueryResultsTestCase.assertEquals((Object)literal, map.get(var));
    }

    public void testXSDIntegerQueryFindSubject() throws Exception {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("hasAge");
        RDFResource individual = cls.createInstance("Klaus");
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("18", this.owlModel.getXSDinteger());
        individual.setPropertyValue(property, literal);
        SPARQLQueryResultsTestCase.assertEquals((Object)literal, (Object)individual.getPropertyValue(property));
        QueryResults results = this.owlModel.executeSPARQLQuery("SELECT ?subject WHERE { ?subject :hasAge 18 }");
        SPARQLQueryResultsTestCase.assertTrue((boolean)results.hasNext());
        Map map = results.next();
        SPARQLQueryResultsTestCase.assertFalse((boolean)results.hasNext());
        SPARQLQueryResultsTestCase.assertEquals((Object)individual, map.get(results.getVariables().get(0)));
    }

    public void testXSDIntQueryFindSubject() throws Exception {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("hasAge");
        RDFResource individual = cls.createInstance("Klaus");
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("18", this.owlModel.getXSDint());
        individual.setPropertyValue(property, literal);
        SPARQLQueryResultsTestCase.assertEquals((Object)new Integer(18), (Object)individual.getPropertyValue(property));
        QueryResults results = this.owlModel.executeSPARQLQuery("SELECT ?subject WHERE { ?subject :hasAge \"18\"^^xsd:int }");
        SPARQLQueryResultsTestCase.assertTrue((boolean)results.hasNext());
        Map map = results.next();
        SPARQLQueryResultsTestCase.assertFalse((boolean)results.hasNext());
        SPARQLQueryResultsTestCase.assertEquals((Object)individual, map.get(results.getVariables().get(0)));
    }

    public void testXSDIntegerQueryFindSubjectAndPredicate() throws Exception {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("hasAge");
        RDFResource individual = cls.createInstance("Klaus");
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("18", this.owlModel.getXSDinteger());
        individual.setPropertyValue(property, literal);
        QueryResults results = this.owlModel.executeSPARQLQuery("SELECT ?subject WHERE { ?subject ?predicate 18 }");
        SPARQLQueryResultsTestCase.assertTrue((boolean)results.hasNext());
        Map map = results.next();
        SPARQLQueryResultsTestCase.assertFalse((boolean)results.hasNext());
        SPARQLQueryResultsTestCase.assertEquals((Object)individual, map.get("subject"));
    }

    public void testXSDIntQueryFindSubjectAndPredicate() throws Exception {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("hasAge");
        RDFResource individual = cls.createInstance("Klaus");
        RDFSLiteral literal = this.owlModel.createRDFSLiteral("18", this.owlModel.getXSDint());
        individual.setPropertyValue(property, literal);
        QueryResults results = this.owlModel.executeSPARQLQuery("SELECT ?subject WHERE { ?subject ?predicate \"18\"^^xsd:int }");
        SPARQLQueryResultsTestCase.assertTrue((boolean)results.hasNext());
        Map map = results.next();
        SPARQLQueryResultsTestCase.assertFalse((boolean)results.hasNext());
        SPARQLQueryResultsTestCase.assertEquals((Object)individual, map.get("subject"));
    }
}

