/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class RepositoryFileManager {
    public static final String REPOSITORY_EXTENTION = ".repository";
    public static final String GLOBAL_REPOSITORY_FILE_NAME = "global.repository";
    private RepositoryManager manager;
    private OWLModel model;

    public RepositoryFileManager(OWLModel model) {
        this.model = model;
        this.manager = this.model.getRepositoryManager();
    }

    public void loadProjectRepositories() {
        File file = this.getProjectRepositoryFile();
        if (file != null && file.exists()) {
            this.manager.removeAllProjectRepositories();
            this.loadRepositoriesFromFile(file, false);
        }
    }

    private void loadGlobalRepositories(File file) {
        if (file.exists()) {
            this.loadRepositoriesFromFile(file, true);
        }
    }

    public void loadGlobalRepositories() {
        File f = ProtegeOWL.getPluginFolder();
        if ((f = new File(f, GLOBAL_REPOSITORY_FILE_NAME)).exists()) {
            this.loadGlobalRepositories(f);
        }
    }

    public void saveProjectRepositories(URI owlFileURI) {
        File file = this.getProjectRepositoryFile(owlFileURI);
        if (file != null) {
            this.saveProjectRepositories(file);
        }
    }

    public void saveProjectRepositories() {
        File file;
        Project project = this.model.getProject();
        if (project != null && project.getProjectURI() != null && (file = this.getProjectRepositoryFile()) != null) {
            this.saveProjectRepositories(file);
        }
    }

    private void saveProjectRepositories(File file) {
        ArrayList<Repository> list = new ArrayList<Repository>();
        for (Repository rep : this.manager.getProjectRepositories()) {
            if (rep.isSystem()) continue;
            list.add(rep);
        }
        if (list.size() > 0) {
            this.saveRepositories(list, file);
        } else {
            file.delete();
        }
    }

    public void saveGlobalRepositories() {
        File pluginsDirectory = PluginUtilities.getPluginsDirectory();
        if (pluginsDirectory != null && pluginsDirectory.exists()) {
            File f = ProtegeOWL.getPluginFolder();
            f = new File(f, GLOBAL_REPOSITORY_FILE_NAME);
            this.saveRepositories(this.manager.getGlobalRepositories(), f);
        }
    }

    private void saveRepositories(List repositories, File file) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (Repository curRep : repositories) {
                String descriptor;
                if (curRep.isSystem() || (descriptor = curRep.getRepositoryDescriptor()) == null || descriptor.length() <= 0) continue;
                writer.write(descriptor);
                writer.write("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException ioEx) {
            System.err.println(ioEx.getMessage());
        }
    }

    private void loadRepositoriesFromFile(File f, boolean global) {
        try {
            String line;
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                RepositoryFactory factory;
                Repository rep;
                if ((line = line.trim()).length() <= 0 || (rep = (factory = RepositoryFactory.getInstance()).createOntRepository(this.model, line)) == null) continue;
                if (global) {
                    this.manager.addGlobalRepository(rep);
                    continue;
                }
                this.manager.addProjectRepository(rep);
            }
        }
        catch (IOException e) {
            System.err.println("[Repository Manager] Warning: Could not find repository file: " + f.toString());
        }
    }

    private File getProjectRepositoryFile() {
        URI projectURI;
        Project project = this.model.getProject();
        if (project != null && (projectURI = project.getProjectURI()) != null) {
            return this.getProjectRepositoryFile(projectURI);
        }
        return null;
    }

    private File getProjectRepositoryFile(URI owlFileURI) {
        File f = new File(owlFileURI);
        String repName = f.getName();
        repName = String.valueOf(repName.substring(0, repName.lastIndexOf("."))) + REPOSITORY_EXTENTION;
        f = new File(f.getParentFile(), repName);
        return f;
    }
}

