/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.impl.DublinCoreDLVersionRedirectRepository;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Iterator;
import java.util.StringTokenizer;

public class RepositoryUtil {
    public static final String FORCE_READ_ONLY_FLAG = "forceReadOnly";

    public static boolean isForcedToBeReadOnly(String query) {
        return RepositoryUtil.getBooleanProperty(FORCE_READ_ONLY_FLAG, query);
    }

    public static boolean getBooleanProperty(String propertyName, String query) {
        if (query != null && query.length() > 0) {
            StringTokenizer tok = new StringTokenizer(query, "&");
            while (tok.hasMoreTokens()) {
                String curNameValuePair = tok.nextToken();
                String curName = curNameValuePair.substring(0, curNameValuePair.indexOf(61));
                String curValue = curNameValuePair.substring(curNameValuePair.indexOf(61) + 1, curNameValuePair.length());
                if (!curName.equals(propertyName)) continue;
                return Boolean.valueOf(curValue);
            }
        }
        return false;
    }

    public static boolean createImportLocalCopy(OWLModel model, URI ontologyURI, File localFile) throws IOException {
        Repository rep = model.getRepositoryManager().getRepository(ontologyURI);
        if (rep != null) {
            String line;
            InputStream is = rep.getInputStream(ontologyURI);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(localFile)));
            while ((line = br.readLine()) != null) {
                bw.write(line);
            }
            bw.flush();
            bw.close();
            br.close();
            model.getRepositoryManager().addProjectRepository(0, new LocalFileRepository(localFile));
            return true;
        }
        return false;
    }

    public static boolean isDublinCoreRedirectedToDLVersion(RepositoryManager manager) {
        Iterator it = manager.getProjectRepositories().iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof DublinCoreDLVersionRedirectRepository)) continue;
            return true;
        }
        return false;
    }

    public static void setDublinCoreRedirectedToDLVersion(RepositoryManager manager, boolean redirect) {
        block2: {
            block1: {
                if (!redirect) break block1;
                if (RepositoryUtil.isDublinCoreRedirectedToDLVersion(manager)) break block2;
                manager.addProjectRepository(0, new DublinCoreDLVersionRedirectRepository());
                break block2;
            }
            for (Repository rep : manager.getProjectRepositories()) {
                if (!(rep instanceof DublinCoreDLVersionRedirectRepository)) continue;
                manager.remove(rep);
                break;
            }
        }
    }
}

