/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.factory.tests;

import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class SWRLJavaFactoryTestCase
extends AbstractJenaTestCase {
    public void testFrameFactoryInstalled() throws Exception {
        this.importSWRL();
        SWRLJavaFactoryTestCase.assertTrue((boolean)(this.owlModel.getFrameFactory() instanceof SWRLJavaFactory));
    }

    private void importSWRL() throws Exception {
        this.loadRemoteOntology("importSWRL.owl");
    }

    public void testFrameFactoryNotInstalled() throws Exception {
        this.loadRemoteOntology("andreas.owl");
        SWRLJavaFactoryTestCase.assertFalse((boolean)(this.owlModel.getFrameFactory() instanceof SWRLJavaFactory));
    }

    public void testSWRLBuiltin() throws Exception {
        this.importSWRL();
        SWRLFactory factory = new SWRLFactory(this.owlModel);
        SWRLBuiltin builtin = factory.createBuiltin("test");
    }

    public void testSWRLVariable() throws Exception {
        this.importSWRL();
        RDFSNamedClass variableClass = this.owlModel.getRDFSNamedClass("swrl:Variable");
        RDFSNamedClass myVariableClass = this.owlModel.createRDFSNamedSubclass("MyVariable", variableClass);
        RDFResource myVariable = myVariableClass.createInstance("x");
        SWRLJavaFactoryTestCase.assertTrue((boolean)(myVariable instanceof SWRLVariable));
    }
}

