/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.constraints;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.List;

public class FindSPARQLAssertsTest
extends AbstractOWLTest
implements RDFResourceTest {
    public FindSPARQLAssertsTest() {
        super(null, null);
    }

    private void addItems(List emptyItems, String iconName, List results, RDFResource instance) {
        for (final String str : emptyItems) {
            results.add(new DefaultOWLTestResult(str, instance, 2, this, OWLIcons.getImageIcon(iconName)){

                public String toString() {
                    return "SPARQL Assertion (at " + this.getHost().getBrowserText() + "): " + str;
                }
            });
        }
    }

    public String getName() {
        return "Find SPARQL assert items";
    }

    public static List getSPARQLAsserts(RDFResource instance, String uri) {
        RDFProperty property;
        ArrayList results = new ArrayList();
        OWLModel owlModel = instance.getOWLModel();
        String propertyName = owlModel.getResourceNameForURI(uri);
        if (propertyName != null && (property = owlModel.getRDFProperty(propertyName)) != null) {
            for (Object value : instance.getPropertyValues(property)) {
                String str = null;
                if (value instanceof RDFSLiteral) {
                    str = ((RDFSLiteral)value).getString();
                    value = str;
                } else {
                    str = value.toString();
                }
                results.add(value);
            }
        }
        return results;
    }

    public List test(RDFResource instance) {
        List emptyItems = FindSPARQLAssertsTest.getSPARQLAsserts(instance, "http://www.owl-ontologies.com/assert.owl#empty");
        List notEmptyItems = FindSPARQLAssertsTest.getSPARQLAsserts(instance, "http://www.owl-ontologies.com/assert.owl#notEmpty");
        ArrayList results = new ArrayList();
        this.addItems(emptyItems, "AssertFalse", results, instance);
        this.addItems(notEmptyItems, "AssertTrue", results, instance);
        return results;
    }
}

