/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PropertyDomainRedundancyTest
extends AbstractOWLTest
implements RDFPropertyTest,
RepairableOWLTest {
    public PropertyDomainRedundancyTest() {
        super("Sanity Tests", "Domain of a property should not contain redundant classes");
    }

    public static Collection fails(OWLObjectProperty slot) {
        HashSet<RDFSClass> results = new HashSet<RDFSClass>();
        HashSet domain = new HashSet(slot.getUnionDomain());
        if (domain.size() >= 2) {
            for (RDFSClass subCls : domain) {
                for (RDFSClass superCls : domain) {
                    if (superCls.equals(subCls) || !subCls.getSuperclasses(true).contains(superCls)) continue;
                    results.add(subCls);
                }
            }
        }
        return results;
    }

    public boolean repair(OWLTestResult testResult) {
        RDFResource host = testResult.getHost();
        if (host instanceof OWLObjectProperty) {
            OWLObjectProperty slot = (OWLObjectProperty)host;
            Collection clses = PropertyDomainRedundancyTest.fails(slot);
            for (RDFSClass cls : clses) {
                slot.removeUnionDomainClass(cls);
            }
            return PropertyDomainRedundancyTest.fails(slot).isEmpty();
        }
        return false;
    }

    public List test(RDFProperty property) {
        Collection failClses;
        if (property instanceof OWLObjectProperty && !(failClses = PropertyDomainRedundancyTest.fails((OWLObjectProperty)property)).isEmpty()) {
            String str = failClses.size() > 1 ? "es " : " ";
            Iterator it = failClses.iterator();
            while (it.hasNext()) {
                RDFSClass cls = (RDFSClass)it.next();
                str = String.valueOf(str) + cls.getBrowserText();
                if (!it.hasNext()) continue;
                str = String.valueOf(str) + ", ";
            }
            return Collections.singletonList(new DefaultOWLTestResult("The domain of " + property.getBrowserText() + " contains the redundant class" + str + ".", property, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

