/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;

public class DeleteMatchingPropertyValuesAction
extends AbstractAction {
    private RDFProperty property;
    private Object value;
    private Collection targetFrames;
    private String type;

    public DeleteMatchingPropertyValuesAction(String type, RDFProperty property, Object value, Collection targetResources) {
        this(type, property, value, targetResources, "annotation");
    }

    public DeleteMatchingPropertyValuesAction(String type, RDFProperty property, Object value, Collection targetResources, String partialName) {
        super("Delete selected " + partialName + " value in " + type + "...", OWLIcons.getDeleteIcon("SubClass"));
        this.property = property;
        this.value = value;
        this.targetFrames = targetResources;
        this.type = type;
    }

    public void actionPerformed(ActionEvent e) {
        OWLModel owlModel = this.property.getOWLModel();
        try {
            try {
                owlModel.beginTransaction("Delete annotation " + this.value + " from property " + this.property.getBrowserText() + " at multiple " + this.type);
                for (RDFResource resource : this.targetFrames) {
                    if (!resource.getPropertyValues(this.property).contains(this.value)) continue;
                    resource.removePropertyValue(this.property, this.value);
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }
}

