/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.TripleSelectable;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.subsumption.TooltippedSelectableTree;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassTree
extends TooltippedSelectableTree
implements TripleSelectable,
HostResourceDisplay {
    public ClassTree(Action doubleClickAction, LazyTreeRoot root) {
        super(doubleClickAction, root);
    }

    public List getPrototypeTriples() {
        ArrayList<DefaultTriple> triples = new ArrayList<DefaultTriple>();
        for (Object sel : this.getSelection()) {
            if (!(sel instanceof RDFSNamedClass)) continue;
            RDFSNamedClass object = (RDFSNamedClass)sel;
            RDFProperty predicate = object.getOWLModel().getRDFSSubClassOfProperty();
            triples.add(new DefaultTriple(null, predicate, object));
        }
        return triples;
    }

    public List getSelectedTriples() {
        ArrayList<DefaultTriple> results = new ArrayList<DefaultTriple>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                LazyTreeNode node;
                Object subject;
                TreePath path = paths[i];
                if (path.getPathCount() > 1 && path.getLastPathComponent() instanceof LazyTreeNode && (subject = (node = (LazyTreeNode)path.getLastPathComponent()).getUserObject()) instanceof RDFSNamedClass) {
                    Object object;
                    RDFSNamedClass subjectClass = (RDFSNamedClass)subject;
                    TreeNode parent = node.getParent();
                    if (parent instanceof LazyTreeNode && (object = ((LazyTreeNode)parent).getUserObject()) instanceof RDFSNamedClass) {
                        RDFSNamedClass objectClass = (RDFSNamedClass)object;
                        RDFProperty predicate = objectClass.getOWLModel().getRDFSSubClassOfProperty();
                        DefaultTriple triple = new DefaultTriple(subjectClass, predicate, objectClass);
                        results.add(triple);
                    }
                }
                ++i;
            }
        }
        return results;
    }

    public void setSelectedTriples(Collection triples) {
    }

    public boolean displayHostResource(RDFResource resource) {
        boolean result = false;
        if (resource instanceof RDFSClass && !this.getSelection().contains(resource)) {
            Collection rootClses = this.getRoots();
            Collection allSupers = ((RDFSClass)resource).getSuperclasses(true);
            for (RDFSClass root : rootClses) {
                if (!allSupers.contains(root)) continue;
                List objectPath = this.getPathToRoot((RDFSClass)resource, root, new LinkedList());
                TreePath path = ComponentUtilities.getTreePath((JTree)((Object)this), (Collection)objectPath);
                if (path != null) {
                    WaitCursor cursor = new WaitCursor((Component)((Object)this));
                    this.scrollPathToVisible(path);
                    this.setSelectionPath(path);
                    this.updateUI();
                    cursor.hide();
                    result = true;
                    continue;
                }
                System.out.println("path = " + objectPath);
            }
        }
        return result;
    }

    public Collection getRoots() {
        return (Collection)((LazyTreeRoot)this.getModel().getRoot()).getUserObject();
    }

    private List getPathToRoot(RDFSClass cls, RDFSClass rootCls, LinkedList list) {
        list.add(0, cls);
        Collection superclasses = cls.getSuperclasses(false);
        for (RDFSClass superclass : superclasses) {
            if (superclass.equals(rootCls)) {
                list.add(0, superclass);
                return list;
            }
            if (!cls.isVisible() || !(superclass instanceof OWLNamedClass)) continue;
            this.getPathToRoot((OWLNamedClass)superclass, rootCls, list);
            break;
        }
        return list;
    }
}

