/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.cls.ConvertToDefinedClassAction;
import edu.stanford.smi.protegex.owl.ui.cls.ConvertToPrimitiveClassAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class ClassTypeConverterWidget
extends AbstractPropertyWidget
implements Disposable {
    private boolean blocked;
    private JCheckBox checkBox;
    private OWLNamedClass cls;
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            ClassTypeConverterWidget.this.updateSelection();
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            ClassTypeConverterWidget.this.updateSelection();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            ClassTypeConverterWidget.this.updateSelection();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            ClassTypeConverterWidget.this.updateSelection();
        }
    };

    public void dispose() {
        if (this.cls != null) {
            this.cls.removeClassListener(this.classListener);
        }
    }

    private void handleChange() {
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
        if (this.cls.getDefinition() != null) {
            ConvertToPrimitiveClassAction.performAction(this.cls);
        } else {
            ConvertToDefinedClassAction.performAction(this.cls);
        }
        tab.ensureClsSelected(this.cls, -1);
        this.updateSelection();
    }

    public void initialize() {
        this.checkBox = new JCheckBox("Has necessary & sufficient conditions ");
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ClassTypeConverterWidget.this.blocked) {
                    ClassTypeConverterWidget.this.handleChange();
                }
            }
        });
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        this.add(this.checkBox);
        this.add(new JLabel(OWLIcons.getPrimitiveClsIcon()));
        this.add(new JLabel("/"));
        this.add(new JLabel(OWLIcons.getImageIcon("DefinedOWLClass")));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals("rdfs:seeAlso");
    }

    public void setCls(OWLNamedClass cls) {
        if (this.cls != null) {
            this.cls.removeClassListener(this.classListener);
        }
        this.cls = cls;
        if (cls != null) {
            cls.addClassListener(this.classListener);
        }
        this.setEnabled(cls != null && cls.isEditable());
        this.updateSelection();
    }

    public void setInstance(Instance newInstance) {
        this.setCls((OWLNamedClass)newInstance);
    }

    private void updateSelection() {
        if (this.cls != null) {
            this.blocked = true;
            this.checkBox.setSelected(this.cls.getDefinition() != null);
            this.blocked = false;
        }
    }
}

