/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;

public class CreateSubclassAction
extends ResourceAction {
    public static final String TEXT = "Create subclass";

    public CreateSubclassAction() {
        super(TEXT, OWLIcons.getCreateIcon("SubClass", 4));
    }

    public void actionPerformed(ActionEvent e) {
        ClassTreePanel classTreePanel = (ClassTreePanel)((Object)this.getComponent());
        RDFSNamedClass sibling = (RDFSNamedClass)this.getResource();
        CreateSubclassAction.performAction(Collections.singleton(sibling), classTreePanel);
    }

    public int getPriority() {
        return 1;
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return component instanceof ClassTreePanel && resource instanceof RDFSNamedClass;
    }

    public static void performAction(Collection superclasses, ClassTreePanel classTreePanel) {
        RDFSNamedClass superclass = (RDFSNamedClass)superclasses.iterator().next();
        OWLModel owlModel = superclass.getOWLModel();
        RDFSClass type = superclass.getProtegeType();
        if (superclasses.contains(owlModel.getOWLThingClass()) && !ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Create_OWLClass) && ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.CreateRDFSClass)) {
            type = owlModel.getRDFSNamedClassClass();
        }
        owlModel.beginTransaction("Create subclass of type " + type.getBrowserText());
        String name = owlModel.createNewResourceName("Class");
        RDFSNamedClass cls = owlModel.createRDFSNamedClass(name, superclasses, type);
        if (cls instanceof OWLNamedClass) {
            for (RDFSNamedClass s : superclasses) {
                ((OWLNamedClass)cls).addInferredSuperclass(s);
            }
        }
        owlModel.endTransaction();
        classTreePanel.setSelectedClass(cls);
    }
}

