/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.clsdesc.AddRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionWidget;
import edu.stanford.smi.protegex.owl.ui.clsdesc.CreateRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.PropertiesDefinitionTableModel;
import edu.stanford.smi.protegex.owl.ui.clsdesc.PropertiesSuperclassesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;

public class PropertiesSuperclassesWidget
extends ClassDescriptionWidget {
    private ResourceSelectionAction addRowAction;
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            PropertiesSuperclassesWidget.this.updateModel();
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            PropertiesSuperclassesWidget.this.updateModel();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            PropertiesSuperclassesWidget.this.updateModel();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            PropertiesSuperclassesWidget.this.updateModel();
        }
    };
    private Action createRowAction;

    protected ResourceSelectionAction createAddAction(ClassDescriptionTable table) {
        this.addRowAction = new AddRowAction(this.getTable(), "Add named class", true);
        return this.addRowAction;
    }

    protected Action createCreateAction(ClassDescriptionTable table) {
        this.createRowAction = new CreateRowAction(this.getTable(), "Create class from expression");
        return this.createRowAction;
    }

    protected List createCustomActions(ClassDescriptionTable table) {
        return Collections.EMPTY_LIST;
    }

    protected Icon createHeaderIcon() {
        return OWLIcons.getSuperclassesIcon();
    }

    protected OWLTableModel createTableModel() {
        return new PropertiesSuperclassesTableModel();
    }

    public void dispose() {
        super.dispose();
        if (this.getEditedCls() != null) {
            this.getEditedCls().removeClassListener(this.classListener);
        }
    }

    protected String getLabelText() {
        return "Superclasses";
    }

    public void setInstance(Instance newInstance) {
        if (this.getEditedCls() != null) {
            this.getEditedCls().removeClassListener(this.classListener);
        }
        super.setInstance(newInstance);
        this.updateModel();
        if (this.getEditedCls() != null) {
            this.getEditedCls().addClassListener(this.classListener);
            boolean thing = this.getKnowledgeBase().getRootCls().equals(this.getEditedCls());
            this.addRowAction.setEnabled(!thing && this.getEditedCls().isEditable());
            this.createRowAction.setEnabled(!thing && this.getEditedCls().isEditable());
        }
    }

    private void updateModel() {
        OWLNamedClass cls = this.getEditedCls();
        if (cls != null) {
            RDFSClass definition = cls.getDefinition();
            if (definition != null) {
                if (!(this.getTable().getModel() instanceof PropertiesDefinitionTableModel)) {
                    PropertiesDefinitionTableModel tableModel = new PropertiesDefinitionTableModel();
                    tableModel.setCls(cls);
                    this.getTable().setModel(tableModel);
                }
                this.getLabeledComponent().setHeaderLabel("Defining Classes");
                this.getLabeledComponent().setHeaderIcon(OWLIcons.getEquivalentClassIcon());
            } else {
                if (!(this.getTable().getModel() instanceof PropertiesSuperclassesTableModel)) {
                    PropertiesSuperclassesTableModel tableModel = new PropertiesSuperclassesTableModel();
                    tableModel.setCls(cls);
                    this.getTable().setModel(tableModel);
                }
                this.getLabeledComponent().setHeaderLabel("Superclasses");
                this.getLabeledComponent().setHeaderIcon(OWLIcons.getSuperclassesIcon());
            }
        }
    }
}

