/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.clsdesc.PropertiesDefinitionTableModel;
import java.util.ArrayList;

public class PropertiesDefinitionTableModelTestCase
extends AbstractJenaTestCase {
    public void testDefinedClassFill() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", superCls);
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(otherCls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(superCls);
        intersectionCls.addOperand(complementCls);
        cls.addEquivalentClass(intersectionCls);
        PropertiesDefinitionTableModel tableModel = new PropertiesDefinitionTableModel();
        tableModel.setCls(cls);
        PropertiesDefinitionTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)complementCls, (Object)tableModel.getClass(1));
    }

    public void testAddRows() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", superCls);
        cls.addEquivalentClass(superCls);
        PropertiesDefinitionTableModel tableModel = new PropertiesDefinitionTableModel();
        tableModel.setCls(cls);
        PropertiesDefinitionTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        tableModel.addRow(otherCls, 0);
        OWLIntersectionClass oldIntersectionCls = (OWLIntersectionClass)cls.getDefinition();
        PropertiesDefinitionTableModelTestCase.assertSize(2, oldIntersectionCls.getOperands());
        PropertiesDefinitionTableModelTestCase.assertContains((Object)superCls, oldIntersectionCls.getOperands());
        PropertiesDefinitionTableModelTestCase.assertContains((Object)otherCls, oldIntersectionCls.getOperands());
        tableModel.addRow(this.owlModel.createOWLComplementClass(otherCls), 1);
        OWLIntersectionClass newIntersectionCls = (OWLIntersectionClass)cls.getDefinition();
        ArrayList operands = new ArrayList(newIntersectionCls.getOperands());
        operands.remove(superCls);
        operands.remove(otherCls);
        PropertiesDefinitionTableModelTestCase.assertSize(1, operands);
        OWLComplementClass complementCls = (OWLComplementClass)operands.iterator().next();
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)otherCls, (Object)complementCls.getComplement());
        PropertiesDefinitionTableModelTestCase.assertFalse((boolean)tableModel.addRow(otherCls, 1));
        PropertiesDefinitionTableModelTestCase.assertFalse((boolean)tableModel.addRow(this.owlModel.createOWLComplementClass(otherCls), 1));
    }

    public void testSetValueAt() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperClass");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Class", superCls);
        cls.addEquivalentClass(superCls);
        PropertiesDefinitionTableModel tableModel = new PropertiesDefinitionTableModel();
        tableModel.setCls(cls);
        PropertiesDefinitionTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        tableModel.addEmptyRow(1);
        tableModel.setValueAt(otherCls.getName(), 1, 0);
        tableModel.removeEmptyRow();
        OWLIntersectionClass oldIntersectionCls = (OWLIntersectionClass)cls.getDefinition();
        PropertiesDefinitionTableModelTestCase.assertSize(2, oldIntersectionCls.getOperands());
        PropertiesDefinitionTableModelTestCase.assertContains((Object)superCls, oldIntersectionCls.getOperands());
        PropertiesDefinitionTableModelTestCase.assertContains((Object)otherCls, oldIntersectionCls.getOperands());
        PropertiesDefinitionTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)otherCls, (Object)tableModel.getClass(0));
        int superClsRow = tableModel.getClassRow(superCls);
        tableModel.setValueAt("not " + otherCls.getName(), superClsRow, 0);
        OWLIntersectionClass newIntersectionCls = (OWLIntersectionClass)cls.getDefinition();
        ArrayList operands = new ArrayList(newIntersectionCls.getOperands());
        operands.remove(otherCls);
        OWLComplementClass complementCls = (OWLComplementClass)operands.iterator().next();
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)otherCls, (Object)complementCls.getComplement());
    }

    public void testSetValueAndReplaceOnlyNamedClass() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperClass");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Class", superCls);
        cls.addEquivalentClass(superCls);
        PropertiesDefinitionTableModel tableModel = new PropertiesDefinitionTableModel();
        tableModel.setCls(cls);
        PropertiesDefinitionTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        PropertiesDefinitionTableModelTestCase.assertEquals((int)1, (int)cls.getSuperclassCount());
        tableModel.setValueAt("not " + superCls.getName(), 0, 0);
        PropertiesDefinitionTableModelTestCase.assertEquals((int)2, (int)cls.getSuperclassCount());
        PropertiesDefinitionTableModelTestCase.assertContains((Object)this.owlThing, cls.getSuperclasses(false));
    }

    public void testDeleteRow() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperClass");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Class", superCls);
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(otherCls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(superCls);
        intersectionCls.addOperand(complementCls);
        cls.addEquivalentClass(intersectionCls);
        PropertiesDefinitionTableModel tableModel = new PropertiesDefinitionTableModel();
        tableModel.setCls(cls);
        PropertiesDefinitionTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        tableModel.deleteRow(1);
        PropertiesDefinitionTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertiesDefinitionTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
    }
}

