/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTableColumns;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTableModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RDFPropertiesTable
extends JTable
implements Disposable,
RDFPropertiesTableColumns {
    private RDFSNamedClass cls;
    private RDFPropertiesTableModel tableModel = new RDFPropertiesTableModel();

    public RDFPropertiesTable() {
        this.setModel(this.tableModel);
        this.setColumnWidth(0, 150);
        this.setColumnWidth(1, 100);
        this.setColumnWidth(2, 150);
        this.setDefaultRenderer(RDFResource.class, (TableCellRenderer)((Object)new ResourceRenderer(){
            private int nextRow;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
                this.nextRow = row;
                return super.getTableCellRendererComponent(table, value, selected, hasFocus, row, col);
            }

            protected void loadSlot(Slot slot) {
                super.loadSlot(slot);
                RDFProperty property = (RDFProperty)slot;
                if (!RDFPropertiesTable.this.tableModel.isDirectProperty(this.nextRow)) {
                    this.setMainIcon(property.getInheritedIcon());
                }
            }
        }));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RDFPropertiesTable.this.handleDoubleClick();
                }
            }
        });
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    public RDFPropertiesTableModel getTableModel() {
        return this.tableModel;
    }

    public void handleAddProperty(RDFProperty property) {
        property.addUnionDomainClass(this.cls);
        this.setSelectedProperty(property);
    }

    protected void handleDoubleClick() {
        int[] rows = this.getSelectedRows();
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            RDFProperty property = this.tableModel.getRDFProperty(row);
            property.getProject().show((Instance)property);
            ++i;
        }
    }

    public void handlePropertyCreated(RDFProperty property) {
        property.setDomain(this.cls);
        this.setSelectedProperty(property);
    }

    private void setSelectedProperty(RDFProperty property) {
        int row = this.tableModel.getRow(property);
        if (row >= 0) {
            this.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    public void handleRemoveProperties() {
        int[] rows = this.getSelectedRows();
        ArrayList<RDFProperty> properties = new ArrayList<RDFProperty>();
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            properties.add(this.tableModel.getRDFProperty(row));
            ++i;
        }
        for (RDFProperty property : properties) {
            property.removeUnionDomainClass(this.cls);
        }
    }

    private void setColumnWidth(int columnIndex, int width) {
        TableColumn col = this.getColumnModel().getColumn(columnIndex);
        col.setPreferredWidth(width);
    }

    public void setClass(RDFSNamedClass cls) {
        this.cls = cls;
        this.tableModel.setClass(cls);
    }
}

