/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableCellHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class AnnotationsLangEditor
extends AbstractCellEditor
implements TableCellEditor {
    private AnnotationsTableCellHolder langHolder;
    private JComboBox comboBox;

    public AnnotationsLangEditor(OWLModel model, JTable table) {
        this.comboBox = ComponentUtil.createLangCellEditor(model, table);
        JPanel holderPanel = new JPanel(new BorderLayout());
        holderPanel.add((Component)this.comboBox, "North");
        holderPanel.setOpaque(false);
        holderPanel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.langHolder = new AnnotationsTableCellHolder(holderPanel, "Center");
        this.langHolder.setOpaque(false);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationsLangEditor.this.stopCellEditing();
            }
        });
    }

    public Object getCellEditorValue() {
        if (this.comboBox.getSelectedItem() != null) {
            return this.comboBox.getSelectedItem().toString();
        }
        return null;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.comboBox.setSelectedItem(value);
        return this.langHolder;
    }
}

